<?php // $Id$
error_reporting(E_ALL);
/**
 * This page holds Clickatell subclass
 * @package SMS
 * @subpackage SMSClickatell
 */

/**
* Clickatell subclass
*
* @package SMS
* @subpackage SMSClickatell
* @author Janne Mikkonen
* @version $Revision: 1.2 $
* @copyright 2005 - 2007 Janne Mikkonen
* @copyright 2005 - 2007 Mediamaisteri Group
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*/
class SMSClickatell extends SMS {

    /**
    * Clickatell API_ID
    * Applies only if Clickatell is used
    * @var integer
    */
    var $ct_api_id;

    /**
    * Clickatell balance limit
    * @var integer
    */
    var $ct_balancelimit = 0;

    /**
    * Callback
    * 0 - Off
    * 1 - Returns only intermediate statuses
    * 2 - Returns only final statuses
    * 3 - Returns both intermediate and final statuses
    * @var integer
    */
    var $ct_callback = 1;

    /**
    * Session identifier
    * @var mixed
    */
    var $ct_session;

    /**
    * Error codes
    * @var array
    */
    var $errorcodes = array(
            '001' => 'Authentication failed',
            '002' => 'Unknown username or password',
            '003' => 'Session id expired',
            '004' => 'Account froze',
            '101' => 'Invalid or missing parameter',
            '102' => 'Invalid UDH (User Data Header)',
            '103' => 'Unknown apimsgid (API Message ID)',
            '104' => 'Unknown climsgid (Client Message ID)',
            '105' => 'Invalid destination address',
            '106' => 'Invalid source address',
            '107' => 'Empty message',
            '108' => 'Invalid or missing api_id',
            '109' => 'Missing message ID',
            '110' => 'Error with e-mail message',
            '111' => 'Invalid protocol',
            '112' => 'Invalid msg_type',
            '113' => 'Max message parts exceeded',
            '114' => 'Cannot route message',
            '115' => 'Message expired',
            '116' => 'Invalid unicode data',
            '120' => 'Invalid delivery time',
            '201' => 'Invalid batch ID',
            '202' => 'No batch template',
            '301' => 'No credit left',
            '302' => 'Max allowed credit');

    /**
    * Message statuses
    * @var array
    */

    var $messagestatus = array(
                '001' => 'Message unknown',
                '002' => 'Message queued',
                '003' => 'Delivered',
                '004' => 'Received by recipient',
                '005' => 'Error with message',
                '006' => 'User cancelled message delivery',
                '007' => 'Error delivering message',
                '008' => 'OK',
                '009' => 'Routing error',
                '010' => 'Message expired',
                '011' => 'Message queued for later delivery',
                '012' => 'Out of credit');

    /**
    * Constructor, PHP 4 style.
    *
    * @param object $config Config values as an object.
    */
    function SMSClickatell (&$config) {
        parent::initialize($config);

        // Setup balance limit.
        $this->ct_balancelimit = $this->balance;

        // Setup api ID
        $this->ct_api_id = $this->clientid;
        if ( empty($this->ct_api_id) ) {
            $this->error("Empty api_id");
        }

        // Setup callback.
        $this->ct_callback = !empty($config->ct_callback) ?
                                    intval($config->ct_callback) : 0;
        // Setup unicode
        $this->unicode = !empty($config->ct_unicode) ? true : false;

        // Setup properties.
        $this->tovar   = 'to';      // Recipient phonenumber.
        $this->fromvar = 'from';    // Sender phonenumber.
        $this->textvar = 'text';    // The message it self
        $this->concat  = 'concat';  // Concatenate long messages.

        // Do authentication and get session id.
        $this->__authenticate();
    }

    /**
     * Constructor, PHP 5 style.
     *
     * @param object $config Configuration values as an object.
     */
    function __construct(&$config) {
        $this->SMSClickatell($config);
    }

    /**
    * Authenticate against Clickatell SMS gateway.
    *
    * Sets up a session on success and on error script exists
    * @access private
    */
    function __authenticate () {

        $command = sprintf("/http/auth?api_id=%s&user=%s&password=%s",
                    $this->ct_api_id,
                    $this->gwuser,
                    $this->gwpass);
        $command = $this->__build_http_cmd($command);
        $this->ct_session = $this->__parse_auth ($this->__exec($command));

    }

    /**
     * Ping the Clickatell SMS Gateway.
     *
     * This method is used to re-new the session id.
     * @access private
     * @return mixed Returns true on success and error message on failure.
     */
    function __ping() {

        $command = sprintf("/http/ping?session_id=%s", $this->ct_session);
        $command = $this->__build_http_cmd($command);

        $response = $this->__get_response_body($this->__exec($command));

        if ( preg_match("/^OK/i", $response) ) {
            return true;
        }

        $errorcode = preg_replace("/[^0-9]/", "", $response);
        return $this->errorcodes[$errorcode];

    }

    /**
    * Query Clickatell message balance
    *
    * @return float  number of SMS credits
    * @access public
    */
    function get_balance () {

        $command = sprintf("/http/getbalance?session_id=%s", $this->ct_session);
        $command = $this->__build_http_cmd($command);

        if ( $response = $this->__get_response_body($this->__exec($command)) ) {
            return $this->__parse_balance($response);
        }

    }

    /**
    * Send SMS message
    *
    * @param to mixed  The destination address.
    * @param text mixed  The text content of the message
    * @param from mixed  The source/sender address
    * @return bool  Return true on success, on failure script dies.
    * @access public
    */
    function send_message($to, $text, $from=NULL) {

        $to   = $this->clean_number($to);
        $from = $this->clean_number($from);

        if (empty($to)) {
            $this->error("Receiver address not specified! Can't send SMS message!");
        }

        if (empty($text)) {
            $this->error("Message is empty! Nothing to send!");
        }

        $from = '';
        if ( !empty($from) ) {
            $from = "&from=$from";
        }

        if ($this->get_balance() < $this->ct_balancelimit) {
            $this->error("You have reach the SMS credit limit!");
        }

        $concat = '';
        if (strlen($text) > 160) {
            $concat = "&". $this->concat ."=3";
        }


        if (strlen($text) > 465) {
            $this->error("Message is too long! Couldn't send message!");
        }

        $text = rawurlencode($text);

        $unicode = '';
        if ($this->unicode) {
            $unicode = "&Unicode=1";
        }

        $command = sprintf("/http/sendmsg?session_id=%s&%s=%s&%s=%s&callback=%d%s%s%s",
                           $this->ct_session,
                           $this->tovar,
                           $to,
                           $this->textvar,
                           $text,
                           $this->ct_callback,
                           $from,
                           $unicode,
                           $concat);

        $command = $this->__build_http_cmd($command);

        if ( $response = $this->__get_response_body($this->__exec($command)) ) {
            return $this->__parse_response($response);
        }
        return false;

    }

    /**
     * Get HTTP response body.
     *
     * Split HTTP response into header and body if request has
     * been successful. If the request has been failed return
     * false.
     *
     * @param string $response.
     * @return mixed Returns string on success and boolean false on fail.
     */
    function __get_response_body (&$response) {
        $status = false;
        if ( preg_match("/^HTTP(S)?\/1\.(1|0) ([0-9]+)/", $response, $match) ) {
            $status = intval($match[3]);
        }

        if ( $status !== 200 ) {
            return false;
        }

        list($header, $body) = preg_split("/\r\n\r\n/", $response);
        return (string) $body;
    }

    /**
    * Get session ID from response
    *
    * @param string $response Response result
    * @return mixed Returns sessionid on success and boolean false on error.
    */
    function __parse_auth (&$response) {

        if (empty($response)) {
            $this->error("Clickatell authentication error! Empty reponse from server!");
        }

        // Get body of the response.
        $body = $this->__get_response_body($response);
        $body = preg_replace("/\s+/", "", $body);
        // Split into code and session indentifier.
        list($code, $session) = preg_split("/\:/", $body);

        if ($code != "OK") {
            // Error occurred. Get error string.
            $error = $this->errornumbers[$session];
            $this->error($error);
        }

        return $session;

    }

    /**
    * Parse getbalance command response text
    *
    * @access private
    * @param $string $response.
    * @return float
    */
    function __parse_balance (&$response) {

        list($code, $number) = preg_split("/\:/", $response);
        $code   = trim($code);
        $number = preg_replace("/[^0-9\.]/", "", $number);

        if ( $code == "ERR" ) {
            $this->error($this->errorcodes[$number]);
        }
        return intval($number);

    }

    /**
     * Was the message sent or did error occur?.
     *
     * @access private
     * @param string $response
     * @return bool
     */
    function __parse_response ($response) {

        if (empty($response)) {
            return false;
        }

        list($code, $msgid) = preg_split("/\:/", $response);
        $code  = trim($code);
        $msgid = trim($msgid);

        if ($code != "ID") {
            $this->error($this->errormessages[$msgid]);
        }

        return true;

    }

    /**
    * Get error code from response
    *
    * @access private
    * @param string $response
    */
    function __get_error_message ($response) {
        $errno = preg_replace("/[^0-9]/", "", $response);
        return $this->errorcodes[$errno];
    }

    /**
     * Get message id
     *
     * @access private
     * @param string $response
     * @return int
     */
    function __get_message_id($response) {
        $msgid = preg_replace("/[^0-9]/", $response);
        return intval($msgid);
    }

    /**
     * Build request string fro HTTP GET method.
     *
     * @param object $data
     * @return string
     */
    function __build_http_cmd ($command) {

        switch ($this->socket) {
            case 'socket':
            case 'fsockopen':

                $command  = 'GET '. $command .' HTTP/1.0' . "\r\n";
                //$command .= "Host: $this->gwhost\r\n";
                $command .= "\r\n";

            break;
            case 'curl':
            break;
        }

        return $command;

    }
}

?>