<?php // $Id$

/**
 * Connection_curl sub class
 *
 * This file contains an interface for curl functions
 * used in connection class.
 *
 * @package Connection
 * @author Janne Mikkonen
 * @version 1.1
 * @copyright 2007 - 2011 Janne Mikkonen <janne dot mikkonen at julmajanne dot com>
 * @copyright 2007 Mediamaisteri Group
 * @license http://www.opensource.org/licenses/mit-license.php MIT License
 */

/**
 * Connection_curl sub class
 *
 * @package Connection
 * @author Janne Mikkonen
 * @author $Author: janne $
 * @version $Revision: 1.2 $
 * @copyright 2007 - 2011 Janne Mikkonen <janne dot mikkonen at julmajanne dot com>
 * @copyright 2007 Mediamaisteri Group
 * @license http://www.opensource.org/licenses/mit-license.php MIT License
 */
class Connection_curl extends Connection {

    /**
     * Socket handle.
     *
     * @var resource
     */
    private $sh = NULL;
    /**
     * Result container.
     * @var string
     */
    private $_result = NULL;
    /**
     * Set protocol.
     *
     * Override parent property. In curl we need to use
     * either http or https.
     * @var string $_proto
     */
    private $_proto = 'http';

    /**
     * @var int
     */
    private $_port = 80;

    /**
     * Include header
     *
     * Include the header into response.
     * @var bool
     */
    private $_includeheader = true;

    /**
     * Constructor.
     *
     * @param string $host Hostname or IP-address
     * @param int $port Port number
     * @param string $type interface name
     */
    public function __construct($host, $port, $type) {
        parent::Setup($type);
        $this->_host  = $host;
        $this->_port  = $port;
        // Initialize curl.
        if ( !$this->sh = curl_init() ) {
            throw new Exception("Could not initialize curl!");
        }

        // TRUE to return the transfer as a string of the return value of
        // curl_exec() instead of outputting it out directly.
        $this->setOption(CURLOPT_RETURNTRANSFER, true);

        // Include header into response.
        if ( $this->_includeheader ) {
            $this->setOption(CURLOPT_HEADER, true);
        }

    }

    /**
     * Open connection
     *
     * Opens a connection to required host
     * @return mixed
     */
    public function Open () {
        if ( !$this->sh ) {
            return false;
        }
        return true;
    }

    /**
     * Close connection.
     *
     * @return void
     */
    public function Close () {
        if ( $this->sh ) {
            curl_close($this->sh);
            $this->sh  = null;
            return true;
        }
        return false;
    }

    public function setOption ($option, $value) {
        curl_setopt($this->sh, $option, $value);
    }

    public function setSecure () {
        $this->setOption(CURLOPT_SSL_VERIFYPEER, 0);
    }

    /**
     * Write data
     *
     * Send data to server.
     * @param string $data Data to send
     * @param int $length Length of data
     * @return bool
     */
    public function Write ($data) {
        if ( $this->sh ) {

            $url = sprintf("%s://%s:%d%s",
                           $this->_proto,
                           $this->_host,
                           $this->_port,
                           $data);

            $this->setOption(CURLOPT_URL, $url);

            if ( !$this->_result = curl_exec($this->sh) ) {
                $error = curl_error($this->sh);
                $errno = curl_errno($this->sh);
                throw new Exception("{$error} {$errno}");
            }
        } else {
            throw new Exception("Connection closed! Cannot write!");
        }
        return false;
    }

    /**
     * Read data from connection
     *
     * @return string
     */
    public function Read () {
        $result = false;
        if ( $this->sh ) {
            $result = $this->_result;
        } else {
            throw new Exception("Cannot read! Connection closed!");
        }
        $this->_result = null;
        return $result;
    }

}
?>
