<?php // $Id: smslib.php,v 1.4 2007/05/05 11:18:00 janne Exp $
    error_reporting(E_ALL);
/**
 * This page contains base Short Message Service (SMS) class.
 *
 * @package SMS
 * @copyright 2005 - 2007 Janne Mikkonen
 * @copyright 2005 - 2007 Mediamaisteri Group
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @version $Revision: 1.4 $
 */

    define('SMSCLASSDIR', dirname(__FILE__));
/**
 * SMS Class.
 *
 * Short Message Service class.
 * @packege SMS
 * @author Janne Mikkonen
 * @copyright 2005 - 2007 Janne Mikkonen
 * @copyright 2005 - 2007 Mediamaisteri Group
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 */
class SMS {

    var $gwhost    = 'localhost';
    var $gwproto   = 'http';
    var $gwport    = 80;
    var $gwuser    = NULL;
    var $gwpass    = NULL;
    var $socket    = 'fsockopen';
    var $timelimit = 30;
    var $gwsoftware = NULL;
    var $proxy      = NULL;
    var $proxyuser  = NULL;
    var $proxypass  = NULL;
    var $clientid   = NULL;
    var $balance    = NULL;
    var $maxlength  = 160; // Maxlength of sms message.
    var $useragent  = 'PHP-GEN-SMS_CLASS/1.0';
    var $recipientdelim = false;

    /**
     * Initialize an object
     *
     * @param object $c Configuration info as an object.
     * @return void
     */
    function initialize (&$c) {
        $this->gwhost     = $this->get_cfg_value($c, 'gwhost');
        $this->gwproto    = $this->get_cfg_value($c, 'gwproto');
        $this->gwport     = $this->get_cfg_value($c, 'gwport');
        $this->gwuser     = $this->get_cfg_value($c, 'gwuser');
        $this->gwpass     = $this->get_cfg_value($c, 'gwpass');
        $this->socket     = $this->get_cfg_value($c, 'gwsocketinterface');
        $this->timelimit  = $this->get_cfg_value($c, 'timelimit');
        $this->gwsoftware = $this->get_cfg_value($c, 'gwclient');
        $this->proxy      = $this->get_cfg_value($c, 'proxy');
        $this->proxyuser  = $this->get_cfg_value($c, 'proxyuser');
        $this->proxypass  = $this->get_cfg_value($c, 'proxypass');
        $this->clientid   = $this->get_cfg_value($c, 'ct_api_id');
        $this->balance    = $this->get_cfg_value($c, 'ct_balancelimit');
    }

    /**
     * Get configuration property value from configuration object.
     *
     * @param object $cnf Configuration object.
     * @param string $prop Property name.
     * @return mixed
     */
    function get_cfg_value($cnf, $prop) {
        return (!empty($cnf->{$prop}) ? $cnf->{$prop} :
               (isset($this->{$prop}) ? $this->{$prop} : NULL));
    }

    /**
     * Find derived class and instantiate an object.
     *
     * @return mixed Returns a new object on success. False on failure.
     */
    function loader(&$CFG) {

        // Test that this method is not called from
        // already instantiated object. Meaning that
        // you cannot call this method from derived class.
        $test = debug_backtrace();
        if ( !empty($test[0]) ) {
            if ( !empty($test[0]['object']) ) {
                SMS::error("You cannot re-instantiate this object!!!");
            }
        }

        if ( empty($CFG->gwclient) ) {
            return false;
        }

        $classname = 'SMS' . ucfirst($CFG->gwclient);
        $path = SMSCLASSDIR .'/'.
                $CFG->gwclient .'/'.
                $CFG->gwclient .'.class.php';
        if ( !file_exists($path) ) {
            return false;
        }

        include_once($path);
        return new $classname($CFG);

    }

    /**
    * Method to get socket interface
    *
    * @access private
    * @return string
    */
    function __get_send_method () {

        // use curl whenever it is possible
        if (function_exists('curl_init')) {
            return 'curl';
        }

        // fsockopen is before socket 'cause fsockopen
        // also supports ssl connections.
        if (function_exists('fsockopen')) {
            return 'fsockopen';
        }

        if (function_exists('socket_create')) {
            return 'socket';
        }

    }

    /**
     * Print error message and exit.
     *
     * @param string $message
     * @return void;
     */
    function error ($message) {
        print '<div style="text-align: center; color: red">';
        print strip_tags($message, '<p><em><i><b><strong><div><br>');
        print '</div>';
        exit;
    }

    /**
     * Send text message.
     *
     * This method should be implemented in derived class. This is
     * just a skeleton and does noting.
     *
     * @param mixed $to Receiver/receivers mobile phone number(s)
     * @param string $text Message it self.
     * @param string $from Senders mobile phone number.
     * @param string $clientid Client information to pass to sms gateway.
     * @return bool
     */
    function send_message ($to, $text, $from=NULL) {
        return false;
    }

    /**
     * Send multimedia message.
     *
     * If gateway is able to handle or forward mms messages,
     * this method should be implemented in derived class.
     * Required data fields:
     * <code>
     *     $data->phonenumber = receiver gsm phone number.
     *     $data->from = sender gsm phone number or email address.
     *     $data->subject = subject of the message.
     * </code>
     * Optional data fields:
     * <code>
     *     $data->text = text message sent with mms.
     * </code>
     * File fields:
     * <code>
     *     $data->file = array("filename" => "<filename>",
     *                         "filedata" => "<filedata>");
     * </code>
     *
     * @param string $to Recipients number(s).
     * @param object $data Data to send.
     * @return mixed
     */
    function send_mms_message ($to, $data) {
        SMS::error("MMS messages are not supported!");
    }

    /**
     * Create a base64 encoded HTTP authentication header.
     *
     * @param string $user Username.
     * @param string $passwd Password.
     * @return string
     */
    function base64_auth_string ($user, $passwd) {
        $strauth = $user .':'. $passwd;
        $strauth = base64_encode($strauth);

        $auth  = 'Authorization: Basic ';
        $auth .= $strauth . "\r\n";

        return $auth;
    }

    /**
     * Count the message length.
     *
     * Short message service is bound to 160 characters.
     * Gateways usually can send longer messages by compining messages
     * using udh information and mobile phones can reconstruct these
     * message using that information. This sets the maximum length
     * of message that can be sent.
     *
     * @param string $message SMS Message.
     * @param int $limit Maximum number of characters in message
     * @param bool $chop Chop long message into max length when set to true.
     * @return mixed
     */
    function msglen ($message, $limit=0, $chop=false) {

        if (empty($message)) {
            return false;
        }

        $limit = ($limit > 0) ? $limit : $this->maxlength;

        if ( !$chop ) {
            if ( strlen($message) <= $limit ) {
                return true;
            }
            return false;
        } else {
            if ( strlen($message) > $limit ) {
                return substr($message, 0, $limit);
            }
            return $message;
        }
    }

    /**
     * fsockopen/socket/curl client interface
     *
     * Connect to sms gateway via Connection class which
     * includes interfaces for fsockopen and socket.
     *
     * @param string $command Command string to send.
     * @param string $iface Interface name ( fsockopen or socket ).
     * @return mixed.
     */
    function __socket ($command, $iface) {

        include_once(dirname(realpath(__FILE__)) .'/class.connection.php');

        $secure = false;
        // If https protocol requested then force
        // interface to fsockopen.
        if ( $this->gwproto == 'https' ) {
            //$iface = 'fsockopen';
            $secure = true;
        }

        // instantiate connection class.
        if ( !$conn = Connection::Init($this->gwhost, $this->gwport, $iface) ) {
            $this->error("Error while initializing connection!");
        }

        // If https connection used
        if ( $secure ) {
            $conn->setSecure();
        }

        // Curl specific stuff.
        if ( $iface == 'curl' ) {
            // Connect through proxy?
            if (!empty($this->proxy)) {
                // Set proxy settings
                $conn->setOption(CURLOPT_PROXY, $this->proxy);
                // Set proxy user and password if given.
                if (!empty($this->proxyuser) &&
                    !empty($this->proxypass)) {
                    $proxyuserpwd  = $this->proxyuser .':';
                    $proxyuserpwd .= $this->proxypass;
                    $conn->setOption(CURLOPT_PROXYUSERPWD, $proxyuserpwd);
                }
            }
            // Set username and password for basic auth if given
            if (!empty($this->gwuser)) {
                $conn->setOption(CURLOPT_USERPWD,
                                 "$this->gwuser:$this->gwpass");
            }
        }

        if ( !$conn->Open() ) {
            return false;
        }

        $conn->Write($command, strlen($command));

        if ( !$datain = $conn->Read() ) {
            return false;
        }

        $conn->Close();

        return $datain;


    }

    /**
     * Execute send command via selected interface.
     *
     * @param string $command
     * @return mixed
     */
    function __exec ($command) {
        return $this->__socket($command, $this->socket);
    }

    /**
     * Get HTTP response codes.
     *
     * Method can be overrided in derived class.
     *
     * @param mixed $result
     * @return integer HTTP status code
     */
    function parse_http_response ($result, $status=false) {

        if (empty($result)) {
            return false;
        }

        // We don't want status information.
        if ( !$status ) {
            if ( preg_match("/^(HTTP\/1\.[0|1]) ([0-9]+)/", $result, $match) ) {
                return (int) $match[2];
            }
        } else { // We also want status information to be returned.
            $return = '';
            if ( preg_match("/^(HTTP\/1\.[0|1]) ([0-9]+)/", $result, $match) ) {
                $return .= (int) $match[2];
            }
            if ( preg_match("/Status\: ([a-zA-Z0-9\-\_ ]+)\s?/e", $result, $match) ) {
                $return .= ' '. $match[1];
            }
            return $return;
        }

        return false;

    }

    /**
     * Clean phonenumber from unwanted characters.
     *
     * @param string $number
     * @return string
     */
    function clean_number ($number) {

        $number = preg_replace("/[^0-9]/", "", $number);
        return $number;

    }

    /**
     * Check mobile phone number format.
     *
     * The number must start with "+" sign.
     *
     * @param string $number
     * @return bool
     */
    function check_number ($number) {

        if (strlen($number) <= 20) {
            if (eregi("^(\+)([0-9]{5,20})$", $number)) {
                return true;
            }
        }

        return false;

    }

    /**
     * Get SMS gateway client name.
     * @return string
     */
    function get_gw_client () {
        return (string) $this->gwclient;
    }

} // End of SMS Class.

/**
 * Deprecated
 *
 * This backward compatibility function to load
 * SMS library classes. You should use methods
 * implemented in SMS class (loader).
 * @return object
 */
function sms_load_class () {

    return SMS::loader();

}
?>