<?php // $Id: nowsms.class.php,v 1.2 2007/05/05 11:18:00 janne Exp $
/**
 * this page holds SMSNowsms subclass
 * @package SMS
 * @subpackage SMSNowsms
 */

/**
* NowSMS subclass
*
* @package SMS
* @subpackage SMSNowsms
* @author Janne Mikkonen
* @version $Revision: 1.2 $
* @copyright 2005 - 2007 Janne Mikkonen
* @copyright 2005 - 2007 Mediamaisteri Group
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*/
class SMSNowsms extends SMS {

    /**
    * NowSMS gateway PhoneNumber variable name.
    * @var string
    */
    var $varto   = 'PhoneNumber';

    /**
    * NowSMS gateway Sender variable name.
    * @var string
    */
    var $varfrom = 'Sender';

    /**
    * NowSMS gateway Text variable name.
    * @var string
    */
    var $vartext = 'Text';

    /**
    * NowSMS gateway Data variable name.
    * @var string
    */
    var $vardata = 'Data';

    /**
    * NowSMS gateway UDH variable name.
    * @var string
    */
    var $varudh  = 'UDH';

    /**
    * Scriptpath for NowSMS gateways webinterface.
    * @var string
    */
    var $scriptpath  = '/';

    /**
     * Delimiter for multiple recipients
     * @var string
     */
    var $recipientdelim = ",";

    /**
    * Constructor, PHP 4 style.
    *
    * @param object $config Config values as an object.
    */
    function SMSNowsms (&$config) {
        parent::initialize($config);
    }

    /**
     * Constructor, PHP 5 style.
     *
     * @param object $config Configuration values as an object.
     */
    function __construct(&$config) {
        parent::initialize($config);
    }

    function set_script_path ($path) {
        $path = clean_param($path, PARAM_LOCALURL);
        $this->scriptpath = $path;
    }

    /**
    * Send SMS message through Kannel gateway web interface.
    *
    * @param mixed $to Receivers mobilephone number or array of numbers.
    * @param string $text SMS message to send.
    * @param string $from Senders mobilephone number.
    * @return mixed Returns false on failure and HTTP response on success.
    */
    function send_message ($to, $text, $from=NULL) {

        if (!empty($this->gwuser) && !empty($this->gwpass)) {
            $auth = $this->base64_auth_string($this->gwuser, $this->gwpass);
        }

        // Check message length
        if (strlen($text) > 459) {
            return false;
        }

        // Check if recipient address is an array meaning
        // there are multiple recipients for this message.
        if ( is_array($to) && $this->recipientdelim !== false ) {
            $tmp = '';
            for ( $i = 0; $i < sizeof($to); $i++ ) {
                if ( $i > 0 ) {
                    $tmp .= $this->recipientdelim;
                }
                $tmp .= $this->clean_number($to[$i]);
            }
            $to = $tmp;
        } else  {
            $to = $this->clean_number($to);
        }

        $data = new stdClass;
        $data->to   = $to;
        $data->text = $text;
        $data->form = $from;

        if (! empty($auth) ) {
            $data->auth = $auth;
        }

        $command = $this->__build_http_cmd ($data);

        if ($result = $this->__exec($command)) {
            return $this->parse_http_response($result);
        } else {
            return false;
        }

    }

    /**
    * Send MMS message through NowSMS Gateway.
    * Required data fields:
    * <code>
    *     $data['PhoneNumber'] = receiver gsm phone number.
    *     $data['MMSFrom'] = sender gsm phone number or email address.
    *     $data['MMSSubject'] = subject of the message.
    * </code>
    * Optional data fields:
    * <code>
    *     $data['MMSText'] = text message sent with mms.
    * </code>
    * File fields:
    * <code>
    *     $data["MMSFile\"; filename=\"<filename>"] = filedata.
    * </code>
    *
    * @param array $data Necessary data as an array.
    * @return mixed
    */
    function send_mms_message ($recipient, $data_to_send) {
        parent::send_mms_message(NULL, NULL);
    }

    function __build_http_cmd ($data) {

        $to     = '';
        $from   = '';
        $text   = '';

        if (! empty($data->to) ) {
            $to = rawurldecode($data->to);
        }

        if (! empty($data->from) ) {
            $from = rawurlencode($data->from);
        }

        if (! empty($data->text) ) {
            $text = rawurlencode(utf8_encode($data->text));
        }

        $command = sprintf("%s?%s=%s&%s=%s",
                           $this->scriptpath,
                           $this->varto,
                           $to,
                           $this->vartext,
                           $text);

        if (! empty($from) ) {
            $command .= sprintf("&%s=%s",
                                $this->varfrom,
                                $from);
        }

        switch ($this->socket) {
            case 'socket':
            case 'fsockopen':
                $command  = sprintf("GET %s HTTP/1.1\r\n", $command);
                $command .= sprintf("Host: %s:%d\r\n", $this->gwhost, $this->gwport);
                if ( !empty($data->auth) ) {
                    $command .= $data->auth;
                }
                $command .= sprintf("User-Agent: %s\r\n", $this->useragent);
                $command .= "Connection: close\r\n";
                $command .= "\r\n";
            break;
            case 'curl':
            break;
        }

        return $command;

    }

}
?>