<?php // $Id$

/**
 * Connection_curl sub class
 *
 * This file contains an interface for curl functions
 * used in connection class.
 *
 * @package Connection
 * @author Janne Mikkonen
 * @version 1.0
 * @copyright 2007 - Janne Mikkonen <janne dot mikkonen at julmajanne dot com>
 * @copyright 2007 - Mediamaisteri Group
 * @license http://www.opensource.org/licenses/mit-license.php MIT License
 */

/**
 * Connection_curl sub class
 *
 * @package Connection
 * @author Janne Mikkonen
 * @author $Author: janne $
 * @version $Revision: 1.1 $
 * @copyright 2007 - Janne Mikkonen <janne dot mikkonen at julmajanne dot com>
 * @copyright 2007 - Mediamaisteri Group
 * @license http://www.opensource.org/licenses/mit-license.php MIT License
 */
class Connection_curl extends Connection {

    /**
     * Socket handle.
     *
     * @var resource
     */
    var $sh = NULL;
    /**
     * Result container.
     * @var string
     */
    var $_result = NULL;
    /**
     * Set protocol.
     *
     * Override parent property. In curl we need to use
     * either http or https.
     * @var string $_proto
     */
    var $_proto = 'http';

    /**
     * @var int
     */
    var $_port = 80;

    /**
     * Include header
     *
     * Include the header into response.
     * @var bool
     */
    var $_includeheader = true;

    /**
     * PHP 4 constructor.
     *
     * @param string $host Hostname or IP-address
     * @param int $port Port number
     * @param string $type interface name
     */
    function Connection_curl ($host, $port, $type) {
        parent::Setup($type);
        $this->_host  = $host;
        $this->_port  = $port;
        // Initialize curl.
        if ( !$this->sh = curl_init() ) {
            trigger_error("Could not initialize curl!", E_USER_ERROR);
        }

        // TRUE to return the transfer as a string of the return value of
        // curl_exec() instead of outputting it out directly.
        $this->setOption(CURLOPT_RETURNTRANSFER, true);

        // Include header into response.
        if ( $this->_includeheader ) {
            $this->setOption(CURLOPT_HEADER, true);
        }

    }

    /**
     * PHP 5 constructor.
     *
     * @param string $host Hostname or IP-address
     * @param int $port Port number
     * @param string $type interface name
     */
    function __construct($host, $port, $type) {
        $this->Connection_curl($host, $port, $type);
    }

    /**
     * Open connection
     *
     * Opens a connection to required host
     * @return mixed
     */
    function Open () {
        if ( !$this->sh ) {
            return false;
        }
        return true;
    }

    /**
     * Close connection.
     *
     * @return void
     */
    function Close () {
        if ( $this->sh ) {
            curl_close($this->sh);
            $this->sh  = null;
            return true;
        }
        return false;
    }

    function setOption ($option, $value) {
        curl_setopt($this->sh, $option, $value);
    }

    function setSecure () {
        $this->setOption(CURLOPT_SSL_VERIFYPEER, 0);
    }

    /**
     * Write data
     *
     * Send data to server.
     * @param string $data Data to send
     * @param int $length Length of data
     * @return bool
     */
    function Write ($data) {
        if ( $this->sh ) {

            $url = sprintf("%s://%s:%d%s",
                           $this->_proto,
                           $this->_host,
                           $this->_port,
                           $data);

            $this->setOption(CURLOPT_URL, $url);

            if ( !$this->_result = curl_exec($this->sh) ) {
                $error = curl_error($this->sh);
                $errno = curl_errno($this->sh);
                trigger_error($error .' '. $errno, E_USER_ERROR);
            }
        }
        return false;
    }

    /**
     * Read data from connection
     *
     * @return string
     */
    function Read () {
        $result = false;
        if ( $this->sh ) {
            $result = $this->_result;
        }
        $this->_result = null;
        return $result;
    }

}
?>