<?php  // $Id$

/// This page prints a particular instance of netpublish
/// (Replace netpublish with the name of your module)

    require_once('../config.php');
    require_once($CFG->dirroot .'/mod/netpublish/lib.php');

    // Paranoia check B-}
    if (!empty($_GET['section'])) {
        if (!netpublish_is_intval($_GET['section'])) {
            error("Passed variable isn't integer!");
        }
    }

    if (!empty($_GET['article'])) {
        if (!netpublish_is_intval($_GET['article'])) {
            error("Passed variable isn't integer!");
        }
    }

    $id      = optional_param('id',      0, PARAM_INT);     // netpublish id
    $a       = optional_param('a',       0, PARAM_INT);
    $section = optional_param('section', 0, PARAM_INT);     // section id
    $article = optional_param('article', 0, PARAM_INT);     // article id

    if ($id) {
        if (! $cm = get_record("course_modules", "id", $id)) {
            error("Course Module ID was incorrect");
        }

        if (! $course = get_record("course", "id", $cm->course)) {
            error("Course is misconfigured");
        }

        if (! $netpublish = get_record("netpublish", "id", $cm->instance)) {
            error("Course module is incorrect");
        }

    } else {
        if (! $netpublish = get_record("netpublish", "id", $a)) {
            error("Course module is incorrect");
        }
        if (! $course = get_record("course", "id", $netpublish->course)) {
            error("Course is misconfigured");
        }
        if (! $cm = get_coursemodule_from_instance("netpublish", $netpublish->id, $course->id)) {
            error("Course Module ID was incorrect");
        }
    }

    if (! $netpublish->published or $netpublish->published < 1 ) {
        error("You cannot view this netpublish!");
    }

    /*if (!empty($article)) {
        $strtolog = get_string("articleview","netpublish");
        add_to_log($cm->courseid, "netpublish", $strtolog, "view.php?id=$cm->id&section=$section&article=$article", "$cm->name");
    } else {
        add_to_log($cm->courseid, "netpublish", "view", "view.php?id=$cm->id", "$cm->name");
    }*/

/// Print the page header

    // Get strings
    $strnetpublishes    = get_string("modulenameplural", "netpublish");
    $strnetpublish      = get_string("modulename", "netpublish");
    $strcreated         = get_string("created","netpublish");
    $strmodified        = get_string("modified","netpublish");
    $strpublished       = get_string("published","netpublish");
    $strauthor          = get_string("by","netpublish");
    $strreadmore        = get_string("readmore","netpublish");

    print_header("$SITE->fullname: $netpublish->name", "$SITE->fullname",
                 "<a href=\"index.php\">$strnetpublishes</a> -> $netpublish->name",
                  "", "", true);

/// Print the main part of the page

    // The code here

    // get articles of section 0;

    $articles = netpublish_get_articles($section, $cm->instance, $netpublish->fullpage);
    $strnoarticles = '';
    if (empty($articles)) {
        $strnoarticles = '<p style="text-align: center; font-weight: bold;">'. get_string("noarticles","netpublish") .'</p>';
    }

    print_simple_box_start('center', '100%');
    include_once('view_html.php');
    print_simple_box_end();

/// Finish the page
    print_footer();

?>
