<?php // $Id: delete.php,v 1.1 2006/02/01 23:37:43 janne Exp $

    require_once("../../config.php");
    require_once("lib.php");

    $id      = required_param('id',         PARAM_INT); // module id
    $article = required_param('article',    PARAM_INT); // article id
    $skey    = required_param('s');

    if (!confirm_sesskey($skey)) {
        error("Session error!", $CFG->wwwroot .'/mod/netpublish/view.php?id='. $id);
    }

    if ($id) {

        // Get all that I need using only one query
        if (! $info = netpublish_get_record($id) ) {
            error("Course Module ID was incorrect");
        }
    }

    // Construct objects used in Moodle
    netpublish_set_std_classes ($cm, $course, $mod, $info);
    unset($info);

    require_login($course->id);

    $isteacher       = isteacher($course->id);
    $isstudent       = isstudent($course->id);
    $redirectonerror = $CFG->wwwroot .'/mod/netpublish/view.php?id='. $cm->id;

    if (!$isteacher and !$isstudent) {
        error("You have no rights to execute this script!");
    }

    $form = get_record("netpublish_articles", "id", $article);

    // Only article owner or teacher can remove article.

    $canremove = false;

    if (intval($form->publishid) != intval($cm->instance)) {
            error("The article you're trying to delete is not part of this instance!");
    }

    if ($isteacher) {
        $canremove = true;
    }

    if (intval($form->userid) == intval($USER->id)) {
        $canremove = true;
    }

    if (!$canremove) {
        error("You can't remove other authors articles!", $redirectonerror);
    }

    if ($data = data_submitted()) {

        $errors = 0;

        $articleid = clean_param($form->id, PARAM_INT);

        // Delete corresponding locks
        if (! delete_records('netpublish_lock','pageid', $articleid) ) {
            $errors++;
        }

        // Delete corresponding status records

        if (! delete_records('netpublish_status_records', 'articleid', $articleid) ) {
            $errors++;
        }

        if ($errors < 1) {
            if (! delete_records('netpublish_articles', 'id', $articleid)) {
                error("Couldn't delete requested article!", $redirectonerror);
            }
        } else {
            error("Could not delete corresponding values! Can't delete article record!",
                  $redirectonerror);
        }

        $streditsuccess = get_string("deletesuccessful","netpublish", $data->title);
        redirect($CFG->wwwroot ."/mod/netpublish/view.php?id=$cm->id", $streditsuccess, 2);

    } else {

        $strnetpublishes         = get_string("modulenameplural","netpublish");
        $strnetpublish           = get_string("modulename","netpublish");
        $strdeletearticle        = get_string("deletearticle","netpublish");

        if ($course->category) {
            $navigation = "<a href=\"../../course/view.php?id=$course->id\">$course->shortname</a> ->";
        }

        $navigation .= " <a href=\"index.php?id=$course->id\">$strnetpublishes</a> -> ";
        $navigation .= "<a href=\"view.php?id=$cm->id\">$mod->name</a> -> $strdeletearticle";

        $strdeletearticleconfirm = get_string("deletearticleconfirm","netpublish", $form->title);

        print_header("$course->shortname: $mod->name", "$course->fullname",
                    "$navigation",
                    "", "", true, "");
        print_heading($strdeletearticle);
        print_simple_box_start("center");
        if (!empty($form)) {
            include_once('delete.html');
        }
        print_simple_box_end();
        print_footer($course);
    }
?>