<?php // $Id: savecomment.php,v 1.4 2006/08/28 22:06:13 janne Exp $

    require_once("../../config.php");
    require_once("lib.php");

    $diary   = new modLearningdiary();
    $sesskey = required_param('sesskey', PARAM_ALPHANUM);
    $action  = required_param('action',  PARAM_ALPHA);

    if ( !$diary->isteacher ) {
        error("Only teachers can view this page!",
              "$CFG->wwwroot/mod/learningdiary/view.php?id={$diary->cm->id}");
    }

    if ( !confirm_sesskey($sesskey) ) {
        error("Session key error!!!");
    }

    if ( $data = data_submitted() ) {

        if ( !empty($data->cancel) ) {
            redirect("$CFG->wwwroot/mod/learningdiary/view.php?id={$diary->cm->id}");
        }

        $pageid    = required_param('pageid', PARAM_INT);
        $userid    = required_param('userid', PARAM_INT);
        $teacherid = required_param('teacherid', PARAM_INT);

        // Check if page exists.
        if ( !$page = get_record("learningdiary_pages", "id", $pageid,
                                 "learningdiaryid", $diary->module->id) ) {
            error("Requested page does not exists!",
                  "$CFG->wwwroot/mod/learningdiary/view.php?id={$diary->cm->id}");
        }

        // Are we adding new comment or editing existing one???

        if ( $action == 'edit' ) {
            $commentid = required_param('commentid', PARAM_INT);
            $comment = get_record("learningdiary_comments", "id", $commentid,
                                   "userid", $userid, "teacherid", $USER->id);

            // Existing comment found, update it.
            $comment->modified = time();
            $comment->title = addslashes(trim(strip_tags($data->title)));
            $comment->comment = addslashes(trim(strip_tags($data->comment, $ALLOWED_TAGS)));
            $comment->format = intval($data->format);

            if ( !update_record("learningdiary_comments", $comment) ) {
                error(get_string('commentupdatefailed','learningdiary', $comment->title),
                      "$CFG->wwwroot/mod/learningdiary/view.php?id={$diary->cm->id}");
            }
            // Get this pages structureid
            $structureid = get_field("learningdiary_pages", "structureid", "id", $page->id);
            $redirectpage = !empty($structureid) ? $structureid : $page->id;
            $strmessage = get_string('commentupdatesuccess','learningdiary', $comment->title);
            redirect("$CFG->wwwroot/mod/learningdiary/view.php?id={$diary->cm->id}&pageid=$redirectpage",
                     $strmessage, 2);

        } else if ( $action == 'add' ) { // Adding new comment

            $newcomment = new stdClass;
            $newcomment->learningdiaryid = $diary->module->id;
            $newcomment->pageid = $page->id;
            $newcomment->userid = addslashes($userid);
            $newcomment->teacherid = addslashes($teacherid);
            $newcomment->title = addslashes(trim(strip_tags($data->title)));
            $newcomment->comment = addslashes(trim(strip_tags($data->comment, $ALLOWED_TAGS)));
            $newcomment->created = time();
            $newcomment->modified = time();
            $newcomment->format = intval($data->format);

            if ( !insert_record("learningdiary_comments", $newcomment) ) {
                error(get_string('commentaddfailed','learningdiary', $newcomment->title),
                      "$CFG->wwwroot/mod/learningdiary/view.php?id={$diary->cm->id}");
            }

            $structureid = get_field("learningdiary_pages", "structureid", "id", $page->id);
            $redirectpage = !empty($structureid) ? $structureid : $page->id;
            $strmessage = get_string('commentaddsuccess','learningdiary', $newcomment->title);
            redirect("$CFG->wwwroot/mod/learningdiary/view.php?id={$diary->cm->id}&pageid=$redirectpage",
                     $strmessage, 2);
        } else {
            error("Unknown operation request!!!");
        }

    }

    redirect("$CFG->wwwroot/mod/learningdiary/view.php?id={$diary->cm->id}");

?>