<?php // $Id: index.php,v 1.4 2008/03/26 11:04:07 janne Exp $

/// This page lists all the instances of learningdiary in a particular course

    require_once("../../config.php");
    require_once("lib.php");

    $id = required_param('id', PARAM_INT);   // course

    if (! $course = get_record("course", "id", $id)) {
        error("Course ID is incorrect");
    }

    require_login($course->id);

    add_to_log($course->id, "learningdiary", "view all", "index.php?id=$course->id", "");


/// Get all required strings

    $strlearningdiaries = get_string("modulenameplural", "learningdiary");
    $strlearningdiary  = get_string("modulename", "learningdiary");


/// Print the header

    $extlinks = array(array('name' => $strlearningdiaries, 'link' => '', 'type' => 'activity'));
    $navigation = build_navigation($extlinks);
    print_header("$course->shortname: $strlearningdiaries", "$course->fullname", $navigation, "", "", true, "", navmenu($course));

/// Get all the appropriate data

    if (! $learningdiaries = get_all_instances_in_course("learningdiary", $course)) {
        notice("There are no learningdiaries", "../../course/view.php?id=$course->id");
        die;
    }

/// Print the list of instances (your module will probably extend this)

    $timenow = time();
    $strname  = get_string("name");
    $strweek  = get_string("week");
    $strtopic  = get_string("topic");
    $strintro  = get_string('description');

    if ($course->format == "weeks") {
        $table->head  = array ($strweek, $strname, $strintro);
        $table->align = array ("CENTER", "LEFT", "LEFT");
    } else if ($course->format == "topics") {
        $table->head  = array ($strtopic, $strname, $strintro);
        $table->align = array ("CENTER", "LEFT", "LEFT");
    } else {
        $table->head  = array ($strname);
        $table->align = array ("LEFT", "LEFT", "LEFT");
    }

    foreach ($learningdiaries as $learningdiary) {
        if (!$learningdiary->visible) {
            //Show dimmed if the mod is hidden
            $link = sprintf('<a class="dimmed" href="view.php?id=%d">%s</a>',
                            $learningdiary->coursemodule, $learningdiary->name);
        } else {
            //Show normal if the mod is visible
            $link = sprintf('<a href="view.php?id=%d">%s</a>',
                            $learningdiary->coursemodule, $learningdiary->name);
        }

        if ($course->format == "weeks" or $course->format == "topics") {
            $table->data[] = array ($learningdiary->section, $link, $learningdiary->intro);
        } else {
            $table->data[] = array ($link);
        }
    }

    echo "<br />";

    print_table($table);

/// Finish the page

    print_footer($course);

?>
