<?php // $Id: userdiaryedit_form.php,v 1.2 2008/03/28 14:13:34 janne Exp $

    if ( !defined('MOODLE_INTERNAL') ) {
        die("This page cannot be displayed by it self!");
    }

    /**
     * This file contains necessary form definition for
     * Learningdiary module's user diary add form.
     *
     */
    include_once($CFG->libdir .'/formslib.php');

class mod_learningdiary_userdiary_edit_form extends moodleform {

    function definition() {

        global $CFG;
        $mform    =& $this->_form;

        $diary    =& $this->_customdata['diary'];
        $USER     =& $this->_customdata['user'];
        $pageid   =& $this->_customdata['pageid'];
        $oldtitle =& $this->_customdata['oldtitle'];

        // Form definition.
        $mform->addElement('header', 'general', get_string('edit', 'learningdiary', stripslashes($oldtitle)));

        $levels = $diary->_get_level_data(0, $USER->id, true, 0, $pageid);
        $mform->addElement('select', 'parentid', get_string('level','learningdiary'), $levels);
        //$mform->setDefault('parentid', $pageid);

        $mform->addElement('text', 'title', get_string('title', 'learningdiary'), array('size'=>'64'));
        $mform->setType('title', PARAM_TEXT);
        $mform->addRule('title', null, 'required', null, 'client');

        $mform->addElement('htmleditor', 'content', get_string('content', 'learningdiary'));
        $mform->setType('content', PARAM_RAW);
        $mform->setHelpButton('content', array('writing', 'questions', 'richtext'), false, 'editorhelpbutton');
        $mform->addRule('content', get_string('required'), 'required', null, 'client');

        $mform->addElement('hidden','id', $diary->cm->id);
        $mform->addElement('hidden','pageid');
        $mform->addElement('hidden','tab');

        $this->add_action_buttons(true, get_string('savechanges'));
    }

}
?>