CREATE TABLE IF NOT EXISTS prefix_learningdiary (
  id int(10) unsigned NOT NULL auto_increment,
  course int(10) unsigned NOT NULL DEFAULT '0' ,
  name varchar(150) NOT NULL DEFAULT 'No name' ,
  intro blob,
  diarymode varchar(40) NOT NULL DEFAULT 'user' ,
  numbering tinyint(1) unsigned NOT NULL DEFAULT '0' ,
  timecreated int(10) unsigned NOT NULL DEFAULT '0' ,
  timemodified int(10) unsigned NOT NULL DEFAULT '0' ,
  PRIMARY KEY (id),
   KEY prefix_learningdiary_idx (course)
);

CREATE TABLE IF NOT EXISTS prefix_learningdiary_comments (
  id int(10) unsigned NOT NULL auto_increment,
  learningdiaryid int(10) unsigned NOT NULL DEFAULT '0' ,
  pageid int(10) unsigned NOT NULL DEFAULT '0' ,
  userid int(10) unsigned NOT NULL DEFAULT '0' ,
  teacherid int(10) unsigned NOT NULL DEFAULT '0' ,
  title varchar(255) NOT NULL DEFAULT 'No title' ,
  comment blob ,
  created int(10) unsigned NOT NULL DEFAULT '0' ,
  modified int(10) unsigned NOT NULL DEFAULT '0' ,
  format tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (id),
   KEY prefix_learningdiary_comments_idx (learningdiaryid,pageid),
   KEY prefix_learningdiary_comments_user_idx (userid,teacherid)
);

CREATE TABLE IF NOT EXISTS prefix_learningdiary_guided_structure (
  id int(10) unsigned NOT NULL auto_increment,
  parentid int(10) unsigned NOT NULL DEFAULT '0' ,
  learningdiaryid int(10) unsigned NOT NULL DEFAULT '0' ,
  title varchar(255) NOT NULL DEFAULT '0' ,
  information blob,
  available int(10) unsigned NOT NULL DEFAULT '0' ,
  created int(10) unsigned NOT NULL DEFAULT '0' ,
  format tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (id),
   KEY prefix_learningdiary_quided_structure_idx (parentid,learningdiaryid)
);

CREATE TABLE IF NOT EXISTS prefix_learningdiary_page_history (
  id int(10) unsigned NOT NULL auto_increment,
  learningdiaryid int(10) unsigned NOT NULL DEFAULT '0' ,
  pageid int(10) unsigned NOT NULL DEFAULT '0' ,
  modified int(10) unsigned NOT NULL DEFAULT '0' ,
  version varchar(10) NOT NULL DEFAULT '1.0' ,
  content blob ,
  PRIMARY KEY (id),
   KEY prefix_learningdiary_page_history_idx (learningdiaryid,pageid)
);

CREATE TABLE IF NOT EXISTS prefix_learningdiary_pages (
  id int(10) unsigned NOT NULL auto_increment,
  parentid int(10) unsigned NOT NULL DEFAULT '0' ,
  learningdiaryid int(10) unsigned NOT NULL DEFAULT '0' ,
  userid int(10) unsigned NOT NULL DEFAULT '0' ,
  structureid int(10) unsigned NOT NULL DEFAULT '0' ,
  title varchar(150) NOT NULL DEFAULT 'No Title' ,
  content blob ,
  hidden tinyint(1) unsigned NOT NULL DEFAULT '0' ,
  created int(10) unsigned NOT NULL DEFAULT '0' ,
  format tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (id),
   KEY prefix_learningdiary_pages_idx (parentid,learningdiaryid,userid,structureid)
);

