<?php // $Id: userdiaryedit.php,v 1.3.10.2 2008/03/28 14:11:54 janne Exp $

    require_once('../../config.php');
    require_once('lib.php');
    include_once('./forms/userdiaryedit_form.php');

    $diary = new modLearningdiary();

    $skey    = required_param('sesskey', PARAM_ALPHANUM);
    $pageid  = required_param('pageid',  PARAM_INT);

    if (! confirm_sesskey($skey) ) {
        error("Invalid session identifier!!!");
    }

    $usehtmleditor = can_use_html_editor();

    if ( (!$diary->isstudent) or ($diary->isteacher or $diary->isguest) ) {
        error("Only students can add entries to user diary!!!",
              "$CFG->wwwroot/course/view.php?id=$course->id");
    }

    // Get first entry in this diary.

    $form = get_record("learningdiary_pages", "id", $pageid);

    if ( empty($form) ) {
        error("No content! Something went wrong!");
    }

    $mform_learningdiary = new mod_learningdiary_userdiary_edit_form('userdiaryedit.php',
                                                                     array('diary' => $diary,
                                                                           'user'  =>  $USER,
                                                                           'pageid'   => $pageid,
                                                                           'oldtitle' => s($form->title)));

    if ( $diary->isstudent ) {

        if ( $data = $mform_learningdiary->get_data() ) {

            if ( !empty($data->cancel) ) {
                redirect("view.php?id={$diary->cm->id}&amp;tab=1&amp;pageid=$data->pageid");
            }

            if ( !empty($data->pageid) ) {
                // Updating entry.

                $error = array();
                $update = new stdClass;
                $update->id = $pageid;
                $update->parentid = clean_param($data->parentid, PARAM_INT);

                if ( $pageid == $update->parentid ) {
                    $error = 'Page id and parent id cannot be same!!!';
                }

                $update->learningdiaryid = clean_param($diary->module->id, PARAM_INT);
                $update->userid = clean_param($USER->id, PARAM_INT);
                $update->title = stripslashes($data->title);
                $update->title = htmlspecialchars(strip_tags($update->title), ENT_QUOTES);

                if ( empty($update->title) ) {
                    $error = get_string('errornotitle','learningdiary');
                }
                $update->title = addslashes($update->title);

                $update->content  = strip_tags($data->content, $ALLOWED_TAGS);
                $updage->content  = trim($update->content);

                if ( empty($update->content) ) {
                    $error = get_string('errornocontent','learningdiary');
                }

                $update->hidden   = 0;
                $update->format = intval($data->format);

                if ( empty($error) ) {
                    if ( update_record("learningdiary_pages", $update) ) {
                        // Add history entry.
                        if (! $history = get_record_sql("SELECT id, version
                                                     FROM {$CFG->prefix}learningdiary_page_history
                                                     WHERE pageid = $update->id
                                                     ORDER BY id DESC", TRUE) ) {
                            $history = new stdClass;
                        }

                        // Add history only if content changes!
                        if ( strcmp($form->content, $update->content) ) {
                            $history->version = floatval($history->version);
                            $history->version = (string) ($history->version + 0.1);
                            if ( strpos($history->version, ".") === FALSE ) {
                                $history->version .= '.0';
                            }
                            $history->pageid = $pageid;
                            $history->learningdiaryid = $update->learningdiaryid;
                            $history->modified = time();
                            $history->content = $update->content;

                            insert_record("learningdiary_page_history", $history);
                        }

                        add_to_log($diary->course->id, "learningdiary", "Update chapter",
                                   "view.php?id={$diary->cm->id}", "{$diary->module->name}");
                        $strupdatesuccuss = get_string('updatesuccess','learningdiary', stripslashes($update->title));
                        redirect("view.php?id={$diary->cm->id}&amp;pageid=$pageid", $strupdatesuccess, 1);

                    }
                }

                redirect("view.php?id={$diary->cm->id}&amp;pageid=$pageid", "<font color=\"red\">$error</font>", 2);
            }
        }

        $strlearningdiaries = get_string("modulenameplural", "learningdiary");
        $strlearningdiary   = get_string("modulename", "learningdiary");
        $stredit            = get_string('edit', 'learningdiary', stripslashes($form->title));

        $strchaptertitle = get_string('chapter', 'learningdiary');
        $strcontent      = get_string('content', 'learningdiary');
        $strlevel        = get_string('level',   'learningdiary');

        $extlinks = array(array('name' => $stredit, 'link' => '', 'type' => $stredit));
        $navigation = build_navigation($extlinks, $diary->cm);

        print_header("{$diary->course->shortname}: {$diary->module->name}", "{$diary->course->fullname}",
                     $navigation, "", "", true,
                     update_module_button($diary->cm->id, $diary->course->id, $strlearningdiary),
                     navmenu($diary->course, $diary->cm));

        $diary->tabs();

        print_simple_box_start('center', '100%');

        $mform_learningdiary->set_data(array('tab' => 1,
                                             'parentid' => intval($form->parentid),
                                             'pageid'   => intval($form->id),
                                             'title'    => s($form->title),
                                             'content'  => trim($form->content)));
        $mform_learningdiary->display();

        print_simple_box_end();
        print_footer($diary->course);

    }

?>