<?php // $Id: userdiaryadd.php,v 1.6.6.2 2008/03/28 12:29:00 janne Exp $

    require_once('../../config.php');
    require_once('lib.php');
    include_once('./forms/userdiaryadd_form.php');

    $diary = new modLearningdiary();

    $skey    = required_param('sesskey', PARAM_ALPHANUM); // Session key.
    $pageid  = optional_param('pageid', 0, PARAM_INT);   // Page id if we're making sub chapter.

    if (! confirm_sesskey($skey) ) {
        error("Invalid session identifier!!!");
    }

    $usehtmleditor = can_use_html_editor();

    if ( (!$diary->isstudent) or ($diary->isteacher or $diary->isguest) ) {
        error("Only students can add entries to user diary!!!",
              "$CFG->wwwroot/course/view.php?id={$diary->course->id}");
    }

    $mform_learningdiary = new mod_learningdiary_userdiary_add_form('userdiaryadd.php',
                                                                    array('diary'=>$diary,
                                                                          'user' => $USER,
                                                                          'pageid' => $pageid));

    if ( $mform_learningdiary->is_cancelled() ) {
        $redirecturl = sprintf('%s/mod/learningdiary/view.php?id=%d', $CFG->wwwroot, $diary->cm->id);
        if ( $pageid ) {
            $redirecturl = sprintf('%s&amp;pageid=%d', $redirecturl,$pageid);
        }
        redirect($redirecturl);
    }

    if ( $data = $mform_learningdiary->get_data() ) {

        if ( !empty($data->cancel) ) {
            redirect("$CFG->wwwroot/mod/learningdiary/view.php?id={$diary->cm->id}");
        }

        $error = array();
        $newpage = new stdClass;
        $newpage->parentid = clean_param($data->parentid, PARAM_INT);
        $newpage->learningdiaryid = clean_param($diary->module->id, PARAM_INT);
        $newpage->userid = clean_param($USER->id, PARAM_INT);
        $newpage->title = stripslashes($data->title);
        $newpage->title = trim(htmlspecialchars(strip_tags($newpage->title), ENT_QUOTES));

        if ( empty($newpage->title) ) {
            $error['notitle'] = get_string('errornotitle','learningdiary');
        }

        $newpage->title = addslashes($newpage->title);
        $newpage->content = stripslashes($data->content);
        $newpage->content = trim(strip_tags($newpage->content, $ALLOWED_TAGS));

        if ( empty($newpage->content) ) {
            $error['nocontent'] = get_string('errornocontent','learningdiary');
        }

        $newpage->content = addslashes($newpage->content);
        $newpage->hidden  = 0;
        $newpage->created = time();
        $newpage->format = intval($data->format);

        if ( empty($error) ) {
            if ( $newpageid = insert_record("learningdiary_pages", $newpage) ) {

                $history = new stdClass;
                $history->learningdiaryid = $newpage->learningdiaryid;
                $history->pageid = clean_param($newpageid, PARAM_INT);
                $history->modified = $newpage->created;
                $history->version = '1.0';
                $history->content = $newpage->content;

                insert_record("learningdiary_page_history", $history);

                redirect("$CFG->wwwroot/mod/learningdiary/view.php?id={$diary->cm->id}&amp;" .
                         "tab=1&amp;pageid=$newpageid");
            }
        }
    }

    /// Print page.

    $strlearningdiaries = get_string("modulenameplural", "learningdiary");
    $strlearningdiary   = get_string("modulename", "learningdiary");
    $stradd             = get_string('newchapter', 'learningdiary');

    $strchaptertitle = get_string('chapter', 'learningdiary');
    $strcontent      = get_string('content',      'learningdiary');
    $strlevel        = get_string('level',        'learningdiary');

    $extlinks = array(array('name' => $stradd, 'link' => '', 'type' => $stradd));
    $navigation = build_navigation($extlinks, $diary->cm);

    print_header("{$diary->course->shortname}: {$diary->module->name}", "{$diary->course->fullname}",
                 $navigation, "", "", true,
                 update_module_button($diary->cm->id, $diary->course->id, $strlearningdiary),
                 navmenu($diary->course, $diary->cm));

    $diary->tabs();

    print_simple_box_start('center', '100%');

    $mform_learningdiary->set_data(array('tab' => 1));
    $mform_learningdiary->display();

    print_simple_box_end();
    print_footer($diary->course);
?>