<?php //  $Id: guideddiaryedit.php,v 1.4.4.1 2008/03/26 10:59:59 janne Exp $

    require_once("../../config.php");
    require_once("lib.php");

    $diary = new modLearningdiary();

    $skey    = required_param('sesskey', PARAM_ALPHANUM);
    $pageid  = required_param('pageid',  PARAM_INT);

    if (! confirm_sesskey($skey) ) {
        error("Invalid session identifier!!!");
    }

    $usehtmleditor = can_use_html_editor();

    if ( $diary->isstudent ) {

        if ( $data = data_submitted() ) {

            if ( !empty($data->cancel) ) {
                redirect("view.php?id={$diary->cm->id}&amp;tab=1&amp;pageid=$data->pageid");
            }

            if ( $olddata = get_record("learningdiary_pages", "userid", $USER->id,
                                       "structureid", $data->structureid,
                                       "learningdiaryid", $diary->module->id) ) {
                // Updating entry

                $olddata->content = addslashes(trim(strip_tags($data->content, $ALLOWED_TAGS)));
                $olddata->format = intval($data->format);

                if ( update_record("learningdiary_pages", $olddata) ) {

                    if ( !$history = get_record("learningdiary_page_history", "pageid", $olddata->id,
                                               "learningdiaryid", $diary->module->id) ) {
                        $history = new stdClass;
                    }

                    $history->version = floatval($history->version);
                    $history->version = (string) ($history->version + 0.1);
                    if ( strpos($history->version, ".") === FALSE ) {
                        $history->version .= '.0';
                    }
                    $history->pageid = $olddata->id;
                    $history->learningdiaryid = $diary->module->id;
                    $history->modified = time();
                    $history->content = $olddata->content;

                    insert_record("learningdiary_page_history", $history);
                } else {
                   $title = stripslashes($olddata->title);
                   error("Could not update entry $title! Database query error!",
                         "$CFG->wwwroot/mod/learningdiary/view.php?id={$diary->cm->id}&pageid=$olddata->structureid");
                }

            } else {
                // Add new entry.
                if ( !$structure = get_record("learningdiary_guided_structure", "id", $data->structureid) ) {
                    error("Could not add new entry! Unknown structure!",
                          "$CFG->wwwroot/mod/learningdiary/view.php?id={$diary->cm->id}");
                }

                $newrec = new stdClass;
                $newrec->learningdiaryid = $diary->module->id;
                $newrec->parentid = intval($data->parentid);
                $newrec->userid   = intval($USER->id);
                $newrec->structureid = intval($structure->id);
                $newrec->title = $structure->title;
                $newrec->content = addslashes(trim(strip_tags($data->content, $ALLOWED_TAGS)));
                $newrec->created = time();

                if ( $newid = insert_record("learningdiary_pages", $newrec) ) {

                    $history = new stdClass;
                    $history->learningdiaryid = $diary->module->id;
                    $history->pageid = $newid;
                    $history->modified = $newrec->created;
                    $history->content = $newrec->content;

                    if ( !insert_record("learningdiary_page_history", $history) ) {
                        error("Could not add version information about this entry!",
                              "$CFG->wwwroot/mod/learningdiary/view.php?id={$diary->cm->id}&pageid=$newid");
                    }

                } else {
                    error("Could not add new entry! Database query error!",
                          "$CFG->wwwroot/mod/learningdiary/view.php?id={$diary->cm->id}");
                }
                unset($newrec, $history);
            }

            $strupdatesuccuss = get_string('updatesuccess','learningdiary', stripslashes($update->title));
            redirect("view.php?id={$diary->cm->id}&amp;pageid=$data->structureid", $strupdatesuccess, 1);

        }

        // Get first entry in this diary.

        if ( !$form = get_record_sql("SELECT p.*, s.information, s.available FROM
                                      {$CFG->prefix}learningdiary_pages AS p,
                                      {$CFG->prefix}learningdiary_guided_structure AS s
                                      WHERE p.structureid = $pageid
                                      AND s.id = $pageid
                                      AND p.learningdiaryid = s.learningdiaryid
                                      AND p.userid = $USER->id") ) {

            $form = get_record_sql("SELECT id, title, parentid, information, available FROM
                                    {$CFG->prefix}learningdiary_guided_structure
                                    WHERE id = $pageid");
        }

        if ( empty($form) ) {
            error("Could not found suitable entry to edit!!!",
                  "$CFG->wwwroot/mod/learningdiary/view.php?id={$diary->cm->id}");
        }

        if ( $form->available > time() ) {
            $edittime = userdate($form->available);
            error("You cannot edit this entry until $edittime",
                  "$CFG->wwwroot/mod/learningdiary/view.php?id={$diary->cm->id}");
        }

        if ( empty($form->structureid) ) {
            $form->structureid = $pageid;
        }

        if ( empty($form->format) ) {
            $form->format = ($usehtmleditor) ? FORMAT_HTML : FORMAT_MOODLE;
        }

        $strlearningdiaries = get_string("modulenameplural", "learningdiary");
        $strlearningdiary   = get_string("modulename", "learningdiary");
        $stredit            = get_string('edit', 'learningdiary', stripslashes($form->title));

        $strchaptertitle = get_string('chaptertitle', 'learningdiary');
        $strcontent      = get_string('content',      'learningdiary');
        $strlevel        = get_string('level',        'learningdiary');

        $extlinks = array(array('name' => $stredit, 'link' => '', 'type' => $stredit));
        $navigation = build_navigation($extlinks, $diary->cm);
        print_header("{$diary->course->shortname}: {$diary->module->name}", "{$diary->course->fullname}",
                     $navigation, "", "", true,
                     update_module_button($diary->cm->id, $diary->course->id, $strlearningdiary),
                     navmenu($diary->course, $diary->cm));

        $diary->tabs();

        print_simple_box_start('center', '100%');
        print_heading($stredit, 'center');

        ?>

        <form method="post" action="guideddiaryedit.php">
        <input type="hidden" name="id"      value="<?php p($diary->cm->id); ?>" />
        <input type="hidden" name="sesskey" value="<?php p($USER->sesskey); ?>" />
        <input type="hidden" name="tab"     value="1" />
        <input type="hidden" name="pageid"  value="<?php echo !empty($form->id) ? $form->id : 0; ?>" />
        <input type="hidden" name="structureid" value="<?php p($form->structureid) ?>" />
        <table border="0" cellpadding="4" align="center">
        <tr valign="top">
            <td colspan="2">
            <?php
            $options = new stdClass;
            $options->noclean = true;
            print(format_text(stripslashes($form->information), FORMAT_HTML, $options));
            ?>
            </td>
        </tr>
        <tr>
            <td align="right"><strong><?php echo $strchaptertitle ?></strong>:</td>
            <td><input type="text" name="title" size="50" value="<?php print($form->title); ?>" /></td>
        </tr>
        <tr>
            <td align="right" valign="top"><strong><?php echo $strcontent ?></strong>:</td>
            <td valign="top"><?php
            $form->content = !empty($form->content) ? trim(strip_tags($form->content, $ALLOWED_TAGS)) : '';
            print_textarea($usehtmleditor, "20", "60", "", "", "content", trim($form->content), $diary->course->id);
            ?><br />
        <?php
        if ($usehtmleditor) {   /// Trying this out for a while
            print_string('formathtml');
            echo '<input type="hidden" name="format" value="'.FORMAT_HTML.'" />';
        } else {
            choose_from_menu(format_text_menu(), "format", $form->format, "");
        }
        helpbutton("textformat", get_string("helpformatting"));
            ?></td>
        </tr>
        <tr>
            <td colspan="2">&nbsp;</td>
        </tr>
        <tr>
            <td>&nbsp;</td>
            <td><input type="submit" value="<?php print_string('savechanges'); ?>" />
            <input type="submit" name="cancel" value="<?php print_string('cancel'); ?>" /></td>
        </tr>
        </table>
        </form>
        <?php
        print_simple_box_end();

        if ( $usehtmleditor ) {
            use_html_editor();
        }

        print_footer($diary->course);
    }

?>