<?php // $Id: userdiaryadd_form.php,v 1.1.2.1 2008/03/28 12:29:00 janne Exp $

    /**
     * This file contains necessary form definition for
     * Learningdiary module's user diary add form.
     *
     */
    include_once($CFG->libdir .'/formslib.php');

class mod_learningdiary_userdiary_add_form extends moodleform {

    function definition() {

        global $CFG;
        $mform    =& $this->_form;

        $diary  =& $this->_customdata['diary'];
        $USER   =& $this->_customdata['user'];
        $pageid =& $this->_customdata['pageid'];

        // Form definition.
        $mform->addElement('header', 'general', get_string('newchapter', 'learningdiary'));

        $levels = $diary->_get_level_data(0, $USER->id);
        $mform->addElement('select', 'parentid', get_string('level','learningdiary'), $levels);
        $mform->setDefault('parentid', $pageid);

        $mform->addElement('text', 'title', get_string('title', 'learningdiary'), array('size'=>'64'));
        $mform->setType('title', PARAM_TEXT);
        $mform->addRule('title', null, 'required', null, 'client');

        $mform->addElement('htmleditor', 'content', get_string('content', 'learningdiary'));
        $mform->setType('content', PARAM_RAW);
        $mform->setHelpButton('content', array('writing', 'questions', 'richtext'), false, 'editorhelpbutton');
        $mform->addRule('content', get_string('required'), 'required', null, 'client');

        $mform->addElement('hidden','id', $diary->cm->id);
        $mform->addElement('hidden','tab');

        $this->add_action_buttons(true, get_string('savechanges'));

    }


}

?>