<?php  // $Id: diff.php,v 1.3.2.1 2008/03/26 10:59:59 janne Exp $

/// This page prints a particular instance of learningdiary

    require_once("../../config.php");
    require_once("lib.php");

    $diary = new modLearningdiary();

    $skey    = required_param('sesskey', PARAM_ALPHANUM);
    $pageid  = required_param('pageid',  PARAM_INT);   // Current version page id.
    $version = required_param('version', PARAM_INT);   // Page id of version to compare.
    $tab     = optional_param('tab', 2, PARAM_INT);   // Toplevel tab.

    if ( !$currentpage = get_record("learningdiary_pages", "id", $pageid) ) {
        error("Requested page could not be found!!!",
              "$CFG->wwwroot/mod/learningdiary/view.php?id={$diary->cm->id}&sesskey=$USER->sesskey");
    }

    if ( !$comparepage = get_record("learningdiary_page_history", "id", $version) ) {
        error("Requested page could not be found!!!",
              "$CFG->wwwroot/mod/learningdiary/view.php?id={$diary->cm->id}&sesskey=$USER->sesskey");
    }

    $currentversion = get_record_sql("SELECT MAX(version) AS currentversion FROM
                                      {$CFG->prefix}learningdiary_page_history
                                      WHERE pageid = $currentpage->id");
    $currentversion = $currentversion->currentversion;

    $compare = $diary->format_html($comparepage->content);
    $current = $diary->format_html($currentpage->content);

    $diff = $diary->diff($compare, $current);

    // Start page.
    $strchapterhistory = get_string('chapterhistory','learningdiary');
    $strversion   = get_string('version','learningdiary');
    $strdifference = get_string('difference','learningdiary');
    $strdiffbtwversions = get_string('diffbetweenversions','learningdiary');
    $strand             = get_string('and','learningdiary');

    $strlearningdiaries = get_string("modulenameplural", "learningdiary");
    $strlearningdiary   = get_string("modulename", "learningdiary");

    $extlinks = array(
                    array('name' => $strchapterhistory,
                          'link' => sprintf('diaryhistory.php?id=%d&amp;pageid=%d&amp;sesskey=%s&amp;tab=2',
                                            $diary->cm->id, $pageid, $USER->sesskey),
                          'type' => 'activity'),
                    array('name' => $strdifference,
                          'link' => '',
                          'type' => $strdifference)
                     );
    $navigation = build_navigation($extlinks, $diary->cm);
    print_header("{$diary->course->shortname}: {$diary->module->name}", "{$diary->course->fullname}",
                 $navigation, "", "", true,
                 update_module_button($diary->cm->id, $diary->course->id, $strlearningdiary),
                 navmenu($diary->course, $diary->cm));

    $diary->tabs($tab);
    print_simple_box_start('center', '100%');
    print '<h3>'. $strdifference .'</h3>';
    $strback = get_string('back','learningdiary');
    $backurl = !empty($_SERVER['HTTP_REFERER']) ?
               '<a href="'. clean_param(htmlentities($_SERVER['HTTP_REFERER']), PARAM_LOCALURL) .'">' . $strback .'</a>' :
               '<a href="javascript: history.back();">'. $strback .'</a>';
    print '<p>&laquo; '. $backurl .'</p>'."\n";
    print "<p>$strdiffbtwversions: $currentversion $strand $comparepage->version</p>";

    print_simple_box_start('center', '75%','','','diff_table','diff_table');
    print ($diff);

    print_simple_box_end();
    print_simple_box_end();

    print_footer($diary->course);



?>