<?php  // $Id: diaryhistory.php,v 1.3.2.1 2008/03/26 10:59:59 janne Exp $

/// This page prints a page history of learningdiary chapter.

    require_once("../../config.php");
    require_once("lib.php");


    $diary = new modLearningdiary();
    $skey   = required_param('sesskey', PARAM_ALPHANUM);
    $pageid = optional_param('pageid',  0, PARAM_INT);
    $tab    = optional_param('tab',     2, PARAM_INT);

    $usehtmleditor = can_use_html_editor();

    if ( !$diary->isteacher && !empty($_SESSION['learningdiary_studentid']) ) {
        unset($_SESSION['learningdiary_studentid']);
    }

    $studentid = ($diary->isteacher) ?  (!empty($_SESSION['learningdiary_studentid']) ?
                                         intval($_SESSION['learningdiary_studentid']) : 0) :
                                         intval($USER->id);

    $page = get_record("learningdiary_pages", "id", $pageid,
                       "learningdiaryid", $diary->module->id,
                       "userid", $studentid);

    if ( !$page ) {
        if ( !$page = $diary->get_first_user_entry($studentid) ) {
            $page = false;
            $student = '';
        }
    }

    if ( $page ) {
        $pagehistory = get_records_select("learningdiary_page_history",
                                          "pageid = $page->id AND learningdiaryid = {$diary->module->id}",
                                          "id DESC");

        $student     = $diary->get_username($page->userid);
    }

    // Cache some strings
    $strchapterhistory = get_string('chapterhistory','learningdiary');
    $strpagetitle = get_string('chaptertitle','learningdiary');
    $strcreated   = get_string('created','learningdiary');
    $strmodified  = get_string('modified');
    $strversion   = get_string('version','learningdiary');
    $strdifference = get_string('difference','learningdiary');


    $strlearningdiaries = get_string("modulenameplural", "learningdiary");
    $strlearningdiary   = get_string("modulename", "learningdiary");

    $navigation = build_navigation('', $diary->cm);
    print_header("{$diary->course->shortname}: {$diary->module->name}", "{$diary->course->fullname}",
                 $navigation, "", "", true,
                 update_module_button($diary->cm->id, $diary->course->id, $strlearningdiary),
                 navmenu($diary->course, $diary->cm));

    $diary->tabs($tab);
    print_simple_box_start('center', '100%');

    if ( !$page ) {
        print_string('nohistory','learningdiary');
    } else {
        echo '<div style="text-align: center">';
        $diary->print_chaptermenu($studentid, 'diaryhistory.php', 'document.getElementById(\'cptrId\').submit()', $page->id, $tab);
        echo '</div>';

        echo '<h4>' . $strpagetitle .': <a href="view.php?id='.
        s($diary->cm->id) .'&amp;pageid='. ($diary->module->diarymode != LD_USERMODE ?
                                            s($page->structureid) :
                                            s($page->id)) .'">';
        p($page->title);
        echo '</a></h4>';
        echo '<p>'. $strcreated .': ';
        echo (userdate($page->created, "%x %X"));
        echo '</p>';

        $tbl = new stdClass;

        $tbl->head = array($strversion, $strmodified, "&nbsp;");
        $tbl->align = array("center","left", "left");
        $tbl->nowrap = array("", "nowrap", "");
        $tbl->data  = array();

        if ( !empty($pagehistory) ) {
            $count = 0;
            foreach ( $pagehistory as $history ) {
                $row = array();

                // version information
                $version = $history->version;
                $row[]   = $version;
                // modified
                $row[]  = userdate($history->modified, "%x %X");
                // Difference link
                $difflink = '<a href="diff.php?id='. $diary->cm->id .'&amp;sesskey=' .
                            $USER->sesskey .'&amp;pageid='. $page->id .
                            '&amp;version=' . $history->id .'">' .
                            $strdifference .'</a>';

                $row[] = ( $count > 0 ) ? $difflink : "&nbsp;";

                array_push($tbl->data, $row);
                $count++;
            }
        }

        print_table($tbl);
    }

    print_simple_box_end();
    print_footer($diary->course);

?>