CREATE TABLE prefix_learningdiary (
  id SERIAL,
  course integer NOT NULL DEFAULT '0',
  name varchar(150) NOT NULL DEFAULT 'No name',
  intro text,
  diarymode varchar(40) NOT NULL DEFAULT 'user',
  numbering char(1) unsigned NOT NULL DEFAULT '0',
  timecreated integer NOT NULL DEFAULT '0',
  timemodified integer NOT NULL DEFAULT '0',
  PRIMARY KEY (id)
);

CREATE INDEX prefix_learningdiary_idx ON prefix_learningdiary (course);

CREATE TABLE prefix_learningdiary_comments (
  id SERIAL,
  learningdiaryid integer NOT NULL DEFAULT '0',
  pageid integer NOT NULL DEFAULT '0',
  userid integer NOT NULL DEFAULT '0',
  teacherid integer NOT NULL DEFAULT '0',
  title varchar(255) NOT NULL DEFAULT 'No title',
  comment text,
  created integer NOT NULL DEFAULT '0',
  modified integer NOT NULL DEFAULT '0',
  format char(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (id)
);

CREATE INDEX prefix_learningdiary_comments_idx ON prefix_learningdiary_comments(learningdiaryid,pageid);
CREATE INDEX prefix_learningdiary_comments_user_idx ON prefix_learningdiary_comments(userid, teacherid);

CREATE TABLE prefix_learningdiary_guided_structure (
  id SERIAL,
  parentid integer NOT NULL DEFAULT '0',
  learningdiaryid integer NOT NULL DEFAULT '0',
  title varchar(255) NOT NULL DEFAULT '0',
  information text,
  available integer NOT NULL DEFAULT '0',
  created integer NOT NULL DEFAULT '0',
  format char(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (id)
);

CREATE INDEX prefix_learningdiary_guided_structure_idx ON prefix_learningdiary_guided_structure(parentid, learningdiaryid);

CREATE TABLE prefix_learningdiary_page_history (
  id SERIAL,
  learningdiaryid integer NOT NULL DEFAULT '0',
  pageid integer NOT NULL DEFAULT '0',
  modified integer NOT NULL DEFAULT '0',
  version varchar(10) NOT NULL DEFAULT '1.0',
  content text,
  PRIMARY KEY (id)
);

CREATE INDEX prefix_learningdiary_page_history_idx ON prefix_learningdiary_page_history(learningdiaryid,pageid);

CREATE TABLE prefix_learningdiary_pages (
  id SERIAL,
  parentid integer NOT NULL DEFAULT '0',
  learningdiaryid integer NOT NULL DEFAULT '0',
  userid integer NOT NULL DEFAULT '0',
  structureid integer NOT NULL DEFAULT '0',
  title varchar(150) NOT NULL DEFAULT 'No Title',
  content text,
  hidden char(1) NOT NULL DEFAULT '0',
  created integer NOT NULL DEFAULT '0',
  format char(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (id)
);

CREATE INDEX prefix_learningdiary_pages_idx ON prefix_learningdiary_pages(parentid,learningdiaryid,userid,structureid);
