<?php  // $Id: view.php,v 1.2 2006/03/19 13:38:31 janne Exp $

/// This page prints a particular instance of learningdiary

    require_once("../../config.php");
    require_once("lib.php");

    $editing   = optional_param('edit', 'off', PARAM_ALPHA);
    $pageid    = optional_param('pageid', 0, PARAM_INT);
    $studentid = optional_param('student', 0, PARAM_INT);

    $diary = new modLearningdiary(); // Instantiate learningdiary object.
    $usehtmleditor = can_use_html_editor();

    if ( !empty($studentid) ) {
        $_SESSION['learningdiary_studentid'] = ($diary->isteacher) ? $studentid : $USER->id;
    }

    add_to_log($diary->course->id, "learningdiary", "view", "view.php?id={$diary->cm->id}", "{$diary->module->name}");

    if ($diary->course->category) {
        $navigation = "<a href=\"../../course/view.php?id={$diary->course->id}\">{$diary->course->shortname}</a> ->";
    }

    $strlearningdiaries = get_string("modulenameplural", "learningdiary");
    $strlearningdiary   = get_string("modulename", "learningdiary");

    print_header("{$diary->course->shortname}: {$diary->module->name}", "{$diary->course->fullname}",
                 "$navigation <a href=\"index.php?id={$diary->course->id}\">$strlearningdiaries</a> ->".
                 " {$diary->module->name}", "", "", true,
                 update_module_button($diary->cm->id, $diary->course->id, $strlearningdiary),
                 navmenu($diary->course, $diary->cm));


    $diary->tabs();
    print_simple_box_start('center', '100%');

    if ( $diary->isteacher ) {
        $studentid = !empty($_SESSION['learningdiary_studentid']) ?
                     (int) $_SESSION['learningdiary_studentid'] :
                           $studentid;

        $diary->print_student_menu($studentid);
    }

    echo '<table border="0" cellpadding="4" cellspacing="0" width="100%">' . "\n";
    echo '<tr>' . "\n";
    echo '<td width="210" valign="top">';
    if ( $diary->isteacher ) {
        $diary->print_index($studentid);
    } else if ( $diary->isstudent ) {
        $diary->print_index ($USER->id);
    }
    echo '</td>';
    echo '<td width="*" valign="top">';

    if ( empty($pageid) ) {
        if ( $diary->isteacher ) {
            $page = $diary->get_first_user_entry($studentid);
        } else {
            $page = $diary->get_first_user_entry($USER->id);
        }
        if ( !empty($page) ) {
            $pageid = ($diary->module->diarymode != LD_USERMODE) ?
                       $page->structureid : $page->id;
        } else {
            $pageid = 0;
        }
    }

    if ( $diary->isteacher ) {
        $diary->print_page($studentid, $pageid);
    } else if ( $diary->isstudent ) {
        $diary->print_page($USER->id, $pageid);
    }
    echo '</td>' . "\n";
    echo '</tr></table>' . "\n";

    echo '<table border="0" cellpadding="4" cellspacing="0" width="100%">' . "\n";
    echo '<tr>' . "\n";
    echo '<td width="210">&nbsp;</td>' . "\n";
    echo '<td width="*" valign="top">' . "\n";

    if ( $diary->isteacher ) {
        $diary->print_comments($studentid, $pageid);
    } else {
        $diary->print_comments($USER->id, $pageid);
    }

    echo '</td>' . "\n";
    echo '</tr>' . "\n";
    echo '</table>' . "\n";

    print_simple_box_end();
    print_footer($diary->course);

?>
