<?php // $Id: userdiaryedit.php,v 1.3 2006/03/22 14:58:44 janne Exp $

    require_once("../../config.php");
    require_once("lib.php");

    $diary = new modLearningdiary();

    $skey    = required_param('sesskey', PARAM_ALPHANUM);
    $pageid  = required_param('pageid',  PARAM_INT);

    if (! confirm_sesskey($skey) ) {
        error("Invalid session identifier!!!");
    }

    $usehtmleditor = can_use_html_editor();

    if ( (!$diary->isstudent) or ($diary->isteacher or $diary->isguest) ) {
        error("Only students can add entries to user diary!!!",
              "$CFG->wwwroot/course/view.php?id=$course->id");
    }

    if ( $diary->isstudent ) {

        if ( $data = data_submitted() ) {

            if ( !empty($data->cancel) ) {
                redirect("view.php?id={$diary->cm->id}&amp;tab=1&amp;pageid=$data->pageid");
            }

            if ( !empty($data->pageid) ) {
                // Updating entry.

                $error = array();
                $update = new stdClass;
                $update->id = $pageid;
                $update->parentid = clean_param($data->parentid, PARAM_INT);

                if ( $pageid == $update->parentid ) {
                    $error = 'Page id and parent id cannot be same!!!';
                }

                $update->learningdiaryid = clean_param($diary->module->id, PARAM_INT);
                $update->userid = clean_param($USER->id, PARAM_INT);
                $update->title = stripslashes($data->title);
                $update->title = htmlspecialchars(strip_tags($update->title), ENT_QUOTES);

                if ( empty($update->title) ) {
                    $error = get_string('errornotitle','learningdiary');
                }
                $update->title = addslashes($update->title);

                $update->content  = strip_tags($data->content, $ALLOWED_TAGS);
                $updage->content  = trim($update->content);

                if ( empty($update->content) ) {
                    $error = get_string('errornocontent','learningdiary');
                }

                $update->hidden   = 0;
                $update->format = intval($data->format);

                if ( empty($error) ) {
                    if ( update_record("learningdiary_pages", $update) ) {
                        // Add history entry.
                        if (! $history = get_record_sql("SELECT id, version
                                                     FROM {$CFG->prefix}learningdiary_page_history
                                                     WHERE pageid = $update->id
                                                     ORDER BY id DESC", TRUE) ) {
                            $history = new stdClass;
                        }

                        $history->version = floatval($history->version);
                        $history->version = (string) ($history->version + 0.1);
                        if ( strpos($history->version, ".") === FALSE ) {
                            $history->version .= '.0';
                        }
                        $history->pageid = $pageid;
                        $history->learningdiaryid = $update->learningdiaryid;
                        $history->modified = time();
                        $history->content = $update->content;

                        insert_record("learningdiary_page_history", $history);

                        add_to_log($diary->course->id, "learningdiary", "Update chapter",
                                   "view.php?id={$diary->cm->id}", "{$diary->module->name}");
                        $strupdatesuccuss = get_string('updatesuccess','learningdiary', stripslashes($update->title));
                        redirect("view.php?id={$diary->cm->id}&amp;pageid=$pageid", $strupdatesuccess, 1);

                    }
                }

                redirect("view.php?id={$diary->cm->id}&amp;pageid=$pageid", "<font color=\"red\">$error</font>", 2);
            }
        }

        // Get first entry in this diary.

        if ( empty($pageid) ) {
            $form = $diary->get_first_user_entry($USER->id);
        } else {
            $form = get_record("learningdiary_pages", "id", $pageid);
        }

        if ( empty($form) ) {
            $form = new stdClass;
            $form->title   = '';
            $form->content = '';
        }

        $navigation = '';
        if ($diary->course->category) {
            $navigation = "<a href=\"../../course/view.php?id={$diary->course->id}\">{$diary->course->shortname}</a> ->";
        }

        $strlearningdiaries = get_string("modulenameplural", "learningdiary");
        $strlearningdiary   = get_string("modulename", "learningdiary");
        $stredit            = get_string('edit', 'learningdiary', stripslashes($form->title));

        $strchaptertitle = get_string('chapter', 'learningdiary');
        $strcontent      = get_string('content', 'learningdiary');
        $strlevel        = get_string('level',   'learningdiary');

        print_header("{$diary->course->shortname}: {$diary->module->name}", "{$diary->course->fullname}",
                     "$navigation <a href=\"index.php?id={$diary->course->id}\">$strlearningdiaries</a> ->".
                     " {$diary->module->name}",
                     "", "", true,
                     update_module_button($diary->cm->id, $diary->course->id, $strlearningdiary),
                     navmenu($diary->course, $diary->cm));

        $diary->tabs();

        print_simple_box_start('center', '100%');
        print_heading($stredit, 'center');
        ?>

        <form method="post" action="userdiaryedit.php">
        <input type="hidden" name="id"      value="<?php p($diary->cm->id); ?>" />
        <input type="hidden" name="sesskey" value="<?php p($USER->sesskey); ?>" />
        <input type="hidden" name="tab"     value="1" />
        <input type="hidden" name="pageid"  value="<?php echo !empty($pageid) ? $pageid : ''; ?>" />
        <input type="hidden" name="parentid" value="<?php p($form->parentid) ?>" />
        <table border="0" cellpadding="4" align="center">

        <tr>
            <td align="right"><strong><?php echo $strchaptertitle ?></strong>:</td>
            <td><input type="text" name="title" size="50" value="<?php print($form->title); ?>" /></td>
        </tr>
        <tr>
            <td align="right" valign="top"><strong><?php echo $strcontent ?></strong>:</td>
            <td valign="top"><?php
            print_textarea($usehtmleditor, "20", "60", "", "", "content", trim($form->content), $diary->course->id);
            ?><br />
        <?php
        if ($usehtmleditor) {   /// Trying this out for a while
            print_string('formathtml');
            echo '<input type="hidden" name="format" value="'.FORMAT_HTML.'" />';
        } else {
            choose_from_menu(format_text_menu(), "format", $form->format, "");
        }
        helpbutton("textformat", get_string("helpformatting"));
            ?></td>
        </tr>
        <tr>
            <td colspan="2">&nbsp;</td>
        </tr>
        <tr>
            <td>&nbsp;</td>
            <td><input type="submit" value="<?php print_string('savechanges'); ?>" />
            <input type="submit" name="cancel" value="<?php print_string('cancel'); ?>" /></td>
        </tr>
        </table>
        </form>
        <?php
        print_simple_box_end();

        if ( $usehtmleditor ) {
            use_html_editor();
        }

        print_footer($diary->course);
    }

?>