<?php // $Id: restorelib.php,v 1.2 2006/11/17 15:54:33 janne Exp $

    //This php script contains all the stuff to restore
    //learningdiary mods

    //This is the "graphical" structure of the learningdiary mod:
    //
    //                           learningdiary
    //                            (CL,pk->id)
    //                                 |
    //         ---------------------------------------------------
    //         |                                                 |
    // learningdiary_pages                         learningdiary_guided_structure
    //(UL,pk->id, fk->learningdiaryid,----------------(UL,pk->id, fk->learningdiaryid,
    // nt->parentid, fk->structureid)      |           nt->parentid)
    //         |                           |
    // learningdiary_page_history          |
    // (UL,pk->id,fk->learningdiaryid,     |            learningdiary_comments
    //  fk->pageid)                        ---------(UL,pk->id,fk->learningdiaryid,
    //                                                  fk->pageid)
    //
    //
    //
    // Meaning: pk->primary key field of the table
    //          fk->foreign key to link with parent
    //          nt->nested field (recursive data)
    //          CL->course level info
    //          UL->user level info
    //
    // TODO: inner link fix.
    //-----------------------------------------------------------

    function learningdiary_restore_mods($mod,$restore) {

        global $CFG,$db;

        $status = true;

        //Get record from backup_ids
        $data = backup_getid($restore->backup_unique_code,$mod->modtype,$mod->id);

        if ($data) {
            //Now get completed xmlized object
            $info = $data->info;
            //traverse_xmlize($info);                                                                     //Debug
            //print_object ($GLOBALS['traverse_array']);                                                  //Debug
            //$GLOBALS['traverse_array']="";                                                              //Debug

            //Now, build the learningdiary record structure
            $diary = new stdClass;
            $diary->course = $restore->course_id;
            $diary->name = backup_todb($info['MOD']['#']['NAME']['0']['#']);
            $diary->intro = backup_todb($info['MOD']['#']['INTRO']['0']['#']);
            $diary->diarymode = backup_todb($info['MOD']['#']['DIARYMODE']['0']['#']);
            $diary->numbering = backup_todb($info['MOD']['#']['NUMBERING']['0']['#']);
            $diary->timecreated = backup_todb($info['MOD']['#']['TIMECREATED']['0']['#']);
            $diary->timemodified = backup_todb($info['MOD']['#']['TIMEMODIFIED']['0']['#']);

            // Add to database ( creates a copy if there is a existing one ).
            $newid = insert_record("learningdiary", $diary);

            //Do some output
            echo "<li>".get_string("modulename","learningdiary")." \"".format_string(stripslashes($diary->name),true)."\"";
            backup_flush(300);

            if ($newid) {
                //We have the newid, update backup_ids
                backup_putid($restore->backup_unique_code,$mod->modtype,
                             $mod->id, $newid);
                //Now check if want to restore user data and do it.
                if ($restore->mods['learningdiary']->userinfo) {
                    //Restore learningdiary_pages
                    $status = learningdiary_pages_restore_mods ($newid,$info,$restore,$diary->diarymode);
                    if ( $status && $diary->diarymode != 'user' ) {
                        // restore structure.
                        $status = learningdiary_structure_restore_mods($newid, $info, $restore);
                    }
                }
            } else {
                $status = false;
            }
        } else {
            $status = false;
        }

        return $status;
    }

    function learningdiary_pages_restore_mods ($newdiaryid, $info, $restore, $diarymode='user') {
        global $CFG;

        $status = true;

        //Get the discussions array
        $pages = $info['MOD']['#']['PAGES']['0']['#']['PAGE'];

        for ( $i = 0; $i < sizeof($pages); $i++ ) {
            $page_info = $pages[$i];

            $oldid = backup_todb($page_info['#']['ID']['0']['#']);
            $olduserid = backup_todb($page_info['#']['USERID']['0']['#']);
            $page = new stdClass;
            $page->learningdiaryid = $newdiaryid;
            $page->userid = backup_todb($page_info['#']['USERID']['0']['#']);
            $page->parentid = backup_todb($page_info['#']['PARENTID']['0']['#']);
            $page->structureid = backup_todb($page_info['#']['STRUCTUREID']['0']['#']);
            $page->title = backup_todb($page_info['#']['TITLE']['0']['#']);
            $page->content = backup_todb($page_info['#']['CONTENT']['0']['#']);
            $page->hidden = backup_todb($page_info['#']['HIDDEN']['0']['#']);
            $page->created = backup_todb($page_info['#']['CREATED']['0']['#']);
            $page->format = backup_todb($page_info['#']['FORMAT']['0']['#']);

            //We have to recode the userid field
            $user = backup_getid($restore->backup_unique_code,"user",$page->userid);
            if ($user) {
                $page->userid = $user->new_id;
            }

            //The structure is equal to the db, so insert the forum_subscription
            $newid = insert_record ("learningdiary_pages",$page);
            // Add history record for it.
            $history = new stdClass;
            $history->learningdiaryid = $newdiaryid;
            $history->pageid = $newid;
            $history->modified = $page->created;
            $history->version = '1.0';
            $history->content = $page->content;
            insert_record("learningdiary_page_history", $history);
            //Do some output
            if (($i+1) % 50 == 0) {
                echo ".";
                if (($i+1) % 1000 == 0) {
                    echo "<br />";
                }
                backup_flush(300);
            }

            if ($newid) {
                //We have the newid, update backup_ids
                backup_putid($restore->backup_unique_code,"learningdiary_pages",$oldid,
                             $newid);
            } else {
                $status = false;
            }

            if ( $status && $diarymode != 'user' ) {
                // Restore comments.
                $status = learningdiary_comments_restore_mods($newdiaryid, $newid, $page_info, $restore);
            }
        }

        //Now we get every page and recalculate its parent page
        $pages = get_records ("learningdiary_pages","learningdiaryid",$newdiaryid);
        if ($pages) {
            //Iterate over each page
            foreach ($pages as $page) {
                //Get its parent
                $old_parent = $page->parentid;
                //Get its new post_id from backup_ids table
                $rec = backup_getid($restore->backup_unique_code,"learningdiary_pages",$old_parent);
                if ($rec) {
                    //Put its new parent
                    $page->parentid = $rec->new_id;
                } else {
                     $page->parentid = 0;
                }
                //Create temp post record
                $temp_page->id = $page->id;
                $temp_page->parentid = $page->parentid;
                //echo "Updated parent ".$old_parent." to ".$temp_page->parentid."<br />";                //Debug
                //Update post (only parent will be changed)
                $status = update_record("learningdiary_pages",$temp_page);
            }
        }
        return $status;
    }

    function learningdiary_comments_restore_mods($newdiaryid, $newpageid, $info, $restore) {

        global $CFG;
        $status = true;

        $comments = $info['#']['COMMENTS']['0']['#']['ENTRY'];

        for ( $i = 0; $i < sizeof($comments); $i++ ) {
            $c_info = $comments[$i];

            $oldid = backup_todb($c_info['#']['ID']['0']['#']);
            $olduserid = backup_todb($c_info['#']['USERID']['0']['#']);
            $oldteacherid = backup_todb($c_info['#']['TEACHERID']['0']['#']);
            $comment = new stdClass;
            $comment->learningdiaryid = $newdiaryid;
            $comment->pageid = $newpageid;
            $comment->userid = backup_todb($c_info['#']['USERID']['0']['#']);
            $comment->title = backup_todb($c_info['#']['TITLE']['0']['#']);
            $comment->comment = backup_todb($c_info['#']['COMMENT']['0']['#']);
            $comment->created = backup_todb($c_info['#']['CREATED']['0']['#']);
            $comment->modified = backup_todb($c_info['#']['MODIFIED']['0']['#']);
            $comment->format = backup_todb($c_info['#']['FORMAT']['0']['#']);

            // recode userid
            $user = backup_getid($restore->backup_unique_code,"user",$olduserid);
            if ($user) {
                $comment->userid = $user->new_id;
            }
            // Recode teacherid
            $teacher = backup_getid($restore->backup_unique_code,"user",$oldteacherid);
            if ($teacher) {
                $comment->teacherid = $teacher->new_id;
            }

            //The structure is equal to the db, so insert the forum_subscription
            $newid = insert_record ("learningdiary_comments",$comment);

            //Do some output
            if (($i+1) % 50 == 0) {
                echo ".";
                if (($i+1) % 1000 == 0) {
                    echo "<br />";
                }
                backup_flush(300);
            }

            if ($newid) {
                //We have the newid, update backup_ids
                backup_putid($restore->backup_unique_code,"learningdiary_comments",$oldid,
                             $newid);
            } else {
                $status = false;
            }
        }
        return $status;
    }

    function learningdiary_structure_restore_mods($newdiaryid, $info, $restore) {
        global $CFG;

        $status = true;

        //Get the discussions array
        $structures = $info['MOD']['#']['STRUCTURES']['0']['#']['STRUCTURE'];

        for ( $i = 0; $i < sizeof($structures); $i++ ) {
            $s_info = $structures[$i];

            $oldid = backup_todb($s_info['#']['ID']['0']['#']);
            $structure = new stdClass;
            $structure->learningdiaryid = $newdiaryid;
            $structure->parentid = backup_todb($s_info['#']['PARENTID']['0']['#']);
            $structure->title = backup_todb($s_info['#']['TITLE']['0']['#']);
            $structure->information = backup_todb($s_info['#']['INFORMATION']['0']['#']);
            $structure->available = backup_todb($s_info['#']['AVAILABLE']['0']['#']);
            $structure->created = backup_todb($s_info['#']['CREATED']['0']['#']);
            $structure->format = backup_todb($s_info['#']['FORMAT']['0']['#']);

            //The structure is equal to the db, so insert the forum_subscription
            $newid = insert_record ("learningdiary_guided_structure",$structure);

            //Do some output
            if (($i+1) % 50 == 0) {
                echo ".";
                if (($i+1) % 1000 == 0) {
                    echo "<br />";
                }
                backup_flush(300);
            }

            if ($newid) {
                //We have the newid, update backup_ids
                backup_putid($restore->backup_unique_code,"learningdiary_guided_structure",$oldid,
                             $newid);
                // Update pages tables structure field
                set_field("learningdiary_pages", "structureid", $newid,
                          "structureid", $oldid, "learningdiaryid", $newdiaryid);
            } else {
                $status = false;
            }

        }

        //Now we get every page and recalculate its parent page
        $structures = get_records ("learningdiary_guided_structure","learningdiaryid",$newdiaryid);
        if ($structures) {
            //Iterate over each page
            foreach ($structures as $struc) {
                //Get its parent
                $old_parent = $struc->parentid;
                //Get its new post_id from backup_ids table
                $rec = backup_getid($restore->backup_unique_code,"learningdiary_guided_structure",$old_parent);
                if ($rec) {
                    //Put its new parent
                    $struc->parentid = $rec->new_id;
                } else {
                     $struc->parentid = 0;
                }
                //Create temp post record
                $temp_struc->id = $struc->id;
                $temp_struc->parentid = $struc->parentid;
                //echo "Updated parent ".$old_parent." to ".$temp_page->parentid."<br />";                //Debug
                //Update post (only parent will be changed)
                $status = update_record("learningdiary_guided_structure",$temp_struc);
            }
        }
        return $status;
    }

?>