<?php  // $Id: lib.php,v 1.9.2.2 2007/09/24 13:05:17 janne Exp $

    error_reporting(E_ALL);
    define('LD_USERMODE',   'user');
    define('LD_GUIDEDMODE', 'guided');

/// Library of functions and constants for module learningdiary

function learningdiary_add_instance($learningdiary) {
/// Given an object containing all the necessary data,
/// (defined by the form in mod.html) this function
/// will create a new instance and return the id number
/// of the new instance.

    $learningdiary->timemodified = time();

    # May have to add extra stuff in here #

    return insert_record("learningdiary", $learningdiary);
}


function learningdiary_update_instance($learningdiary) {
/// Given an object containing all the necessary data,
/// (defined by the form in mod.html) this function
/// will update an existing instance with new data.

    $learningdiary->timemodified = time();
    $learningdiary->id = $learningdiary->instance;

    # May have to add extra stuff in here #

    return update_record("learningdiary", $learningdiary);
}


function learningdiary_delete_instance($id) {
/// Given an ID of an instance of this module,
/// this function will permanently delete the instance
/// and any data that depends on it.

    if (! $learningdiary = get_record("learningdiary", "id", "$id")) {
        return false;
    }

    $result = true;

    # Delete any dependent records here #
    // Delete pages in this learningdiary
    if (! delete_records("learningdiary_pages", "learningdiaryid", $learningdiary->id) ) {
        return false;
        exit;
    }
    // Delete pages history
    if (! delete_records("learningdiary_page_history","learningdiaryid", $learningdiary->id) ) {
        return false;
        exit;
    }
    // Delete guided structure
    if (! delete_records("learningdiary_guided_structure","learningdiaryid", $learningdiary->id) ) {
        return false;
        exit;
    }
    // Delete comments
    if (! delete_records("learningdiary_comments","learningdiaryid", $learningdiary->id) ) {
        return false;
        exit;
    }
    // Delete learningdiary.
    if (! delete_records("learningdiary", "id", "$learningdiary->id")) {
        $result = false;
    }

    return $result;
}

function learningdiary_user_outline($course, $user, $mod, $learningdiary) {
/// Return a small object with summary information about what a
/// user has done with a given particular instance of this module
/// Used for user activity reports.
/// $return->time = the time they did it
/// $return->info = a short text description

    return $return;
}

function learningdiary_user_complete($course, $user, $mod, $learningdiary) {
/// Print a detailed representation of what a  user has done with
/// a given particular instance of this module, for user activity reports.

    return true;
}

function learningdiary_print_recent_activity($course, $isteacher, $timestart) {
/// Given a course and a time, this module should find recent activity
/// that has occurred in NEWMODULE activities and print it out.
/// Return true if there was output, or false is there was none.

    global $CFG;

    return false;  //  True if anything was printed, otherwise false
}

function learningdiary_cron () {
/// Function to be run periodically according to the moodle cron
/// This function searches for things that need to be done, such
/// as sending out mail, toggling flags etc ...

    global $CFG;

    return true;
}

function learningdiary_grades($learningdiaryid) {
/// Must return an array of grades for a given instance of this module,
/// indexed by user.  It also returns a maximum allowed grade.
///
///    $return->grades = array of grades;
///    $return->maxgrade = maximum allowed grade;
///
///    return $return;

   return NULL;
}

function learningdiary_get_participants($learningdiaryid) {
//Must return an array of user records (all data) who are participants
//for a given instance of NEWMODULE. Must include every user involved
//in the instance, independient of his role (student, teacher, admin...)
//See other modules as example.

    return false;
}

function learningdiary_scale_used ($learningdiaryid,$scaleid) {
//This function returns if a scale is being used by one NEWMODULE
//it it has support for grading and scales. Commented code should be
//modified if necessary. See forum, glossary or journal modules
//as reference.

    $return = false;

    //$rec = get_record("NEWMODULE","id","$learningdiaryid","scale","-$scaleid");
    //
    //if (!empty($rec)  && !empty($scaleid)) {
    //    $return = true;
    //}

    return $return;
}

//////////////////////////////////////////////////////////////////////////////////////
/// Any other board functions go here.  Each of them must have a name that
/// starts with learningdiary_

class modLearningdiary {

    var $cm;
    var $course;
    var $module;
    var $isstudent = false;
    var $isteacher = false;
    var $isguest   = false;
    var $isadmin   = false;

    function modLearningdiary () {
        global $CFG, $USER;
        $id = optional_param('id', 0, PARAM_INT);
        $a  = optional_param('a',  0, PARAM_INT);

        $cm = new stdClass;
        $course = new stdClass;
        $module = new stdClass;

        if ( $id ) {
            if (! $this->cm = get_record("course_modules", "id", $id)) {
                error("Course Module ID was incorrect");
            }

            if (! $this->course = get_record("course", "id", $this->cm->course)) {
                error("Course is misconfigured");
            }

            if (! $this->module = get_record("learningdiary", "id", $this->cm->instance)) {
                error("Course module is incorrect");
            }
        } else {
            if (! $this->module = get_record("learningdiary", "id", $a)) {
                error("Course module is incorrect");
            }
            if (! $this->course = get_record("course", "id", $this->module->course)) {
                error("Course is misconfigured");
            }
            if (! $this->cm = get_coursemodule_from_instance("learningdiary",
                                                             $this->module->id,
                                                             $this->course->id)) {
                error("Course Module ID was incorrect");
            }
        }

        // Always require login for this module.
        require_login($this->course->id);
        // Cache guest, student and teacher information.
        $this->isteacher = $this->isteacher($this->course->id, $USER->id);
        $this->isstudent = $this->isstudent($this->course->id, $USER->id);
        $this->isguest   = $this->isguest($USER->id);
        $this->isadmin   = $this->isadmin($USER->id);

        if ( (!$this->isstudent && !$this->isteacher) or $this->isguest ) {
            error("You cannot view this page as a guest!!!",
                  "$CFG->wwwroot/course/view.php?id={$this->course->id}");
        }

    }

    function __construct() {
        $this->modLearningdiary();
    }

    function isteacher($courseid, $userid) {
        $context = get_context_instance(CONTEXT_COURSE, $courseid);
        return (has_capability('moodle/legacy:teacher', $context, $userid, false)
             or has_capability('moodle/legacy:editingteacher', $context, $userid, false)
             or has_capability('moodle/legacy:admin', $context, $userid, false));
    }

    function isstudent($courseid, $userid) {
        $context = get_context_instance(CONTEXT_COURSE, $courseid);
        return has_capability('moodle/legacy:student', $context, $userid, false);
    }

    function isguest($userid) {
        $context = get_context_instance(CONTEXT_SYSTEM, SITEID);
        return has_capability('moodle/legacy:guest', $context, $userid, false);
    }

    function isadmin($userid) {
        $context = get_context_instance(CONTEXT_SYSTEM, SITEID);
        return has_capability('moodle/legacy:admin', $context, $userid, false);
    }

    function get_username ($userid) {
        $userid   = intval($userid);
        $username = '';
        $user = get_record("user", "id", $userid);

        if ( !empty($user) ) {
            $username = fullname($user);
        }
        unset($user);
        return $username;
    }

    function print_tools($pageid) {
        global $CFG, $USER;
        $edit = optional_param('edit', NULL, PARAM_ALPHA);

        $stradd     = get_string('add');
        $stredit    = get_string('edit');
        $strdelete  = get_string('delete');
        $strhistory = get_string('history','learningdiary');

        echo '<div class="mod_ld_toolbar">';
        if ( $this->module->diarymode != LD_GUIDEDMODE && $this->isstudent ) {

            // Edit mode on off.
            switch( $edit ) {
                case 'on':
                    $USER->editing = 1;
                break;
                case 'off':
                    $USER->editing = 0;
                break;
            }

            echo '<table border="0" cellpadding="2">';
            echo '<tr>';
            if ( $USER->editing ) {
                echo '<td>';
                // Add form.
                $items = array(array('name' => 'id', 'value' => $this->cm->id),
                               array('name' => 'sesskey', 'value' => $USER->sesskey),
                               array('name' => 'pageid', 'value' => $pageid));
                $button = array('value' => $stradd);
                $this->print_get_form('userdiaryadd.php', $items, $button);
                echo '</td><td>';
                // Edit form.
                if ( !empty($pageid) ) {
                    $button = array('value' => $stredit);
                    $this->print_get_form('userdiaryedit.php', $items, $button);
                }
                echo '</td><td>';
                // Delete
                if ( !empty($pageid) ) {
                    $button = array('value' => $strdelete);
                    $this->print_get_form('userdiarydelete.php', $items, $button);
                }
                echo '</td>';
            }
            echo '<td>';

            $editmode = $USER->editing ? 'off' : 'on';
            $items = array(array('name' => 'id', 'value' => $this->cm->id),
                           array('name' => 'sesskey', 'value' => $USER->sesskey),
                           array('name' => 'pageid', 'value' => $pageid),
                           array('name' => 'edit', 'value' => $editmode));

            if ( !$USER->editing ) {
                $streditmode = get_string('turneditingon');
            } else {
                $streditmode = get_string('turneditingoff');
            }
            $button = array('value' => $streditmode);
            $this->print_get_form('view.php', $items, $button);
            echo '</td></tr>';
            echo '</table>';

        }

        echo '</div>';
    }

    function print_index($userid) {
        global $CFG;

        $learningdiaryid = (int) $this->module->id;
        $userid = (int) $userid;

        if ( $this->module->diarymode == LD_USERMODE ) {
            $records = get_records_sql("SELECT id, parentid, title
                                       FROM {$CFG->prefix}learningdiary_pages
                                       WHERE userid = $userid
                                       AND learningdiaryid = $learningdiaryid
                                       AND structureid = '0'
                                       ORDER BY id");
        } else {
            $records = get_records_sql("SELECT id, parentid, title, available
                                       FROM {$CFG->prefix}learningdiary_guided_structure
                                       WHERE learningdiaryid = $learningdiaryid
                                       ORDER BY id");
        }

        if ( !empty($records) ) {
            if ( empty($_GET['pageid']) ) {
                $page = $this->get_first_user_entry($userid);
                if ( !empty($page) ) {
                    $_GET['pageid'] = ($this->module->diarymode != LD_GUIDEDMODE ) ?
                                      $page->id : $page->structureid;
                }
            }
            $this->print_navmenu(0, $records);
        }
    }

    function print_navmenu($parent, $records) {
        global $CFG;
        static $timenow, $strcounter;

        if ( empty($timenow) ) {
            $timenow = time();
        }

        $currentpage = !empty($_GET['pageid']) ? (int) $_GET['pageid'] : 0;
        $count = 1;

        print "<ul class=\"mod_ld_navi_list\">\n";
        foreach ( $records as $record ) {
            $class = !empty($record->available) ?
                     (($timenow <= $record->available) ? 'class="mod_ld_dimmed" ' : '') : '';

            if ( $record->parentid == $parent ) {
                $strcounter .= $count .'.';

                print "\t<li class=\"mod_ld_navi_item\">";
                if ( !empty($this->module->numbering) ) {
                    echo $strcounter . ' ';
                }
                echo "<a " . $class ."href=\"view.php?id={$this->cm->id}";
                if ( empty($class) ) {
                    echo "&amp;pageid=". $record->id;
                }
                echo "\">";
                echo ( $currentpage != $record->id ) ? stripslashes($record->title) :
                     "<strong>". stripslashes($record->title) ."</strong>";
                echo "</a>";

                $count++;
                $this->print_navmenu($record->id, $records);
                print "</li>\n";
            }

        }
        preg_match("/([0-9]+)\.$/i", $strcounter, $match);
        $len = !empty($match[0]) ? strlen($match[0]) - 1 : 1;
        $strcounter = substr($strcounter, 0, strrpos($strcounter, ".") - $len);
        //$strcounter = substr($strcounter, 0, (strlen($strcounter) - 2) );
        print "</ul>\n";
    }

    function get_first_user_entry ($userid) {

        global $CFG;
        $ldid   = intval($this->module->id);
        $userid = intval($userid);

        if ( empty($ldid) or empty($userid) ) {
            return false;
        }

        if ( $this->module->diarymode != LD_GUIDEDMODE ) {
            $extclause = 'AND structureid = 0';
        } else {
            $extclause = 'AND structureid > 0';
        }

        return get_record_sql("SELECT * FROM
                              {$CFG->prefix}learningdiary_pages
                              WHERE learningdiaryid = '$ldid'
                              AND userid = '$userid'
                              AND parentid = 0
                              $extclause
                              ORDER BY id", TRUE);
    }

    function _get_page($userid, $pageid=0) {

        global $CFG;
        $ldid   = intval($this->module->id);
        $userid = intval($userid);
        $pageid = intval($pageid);

        if ( empty($userid) || empty($ldid) ) {
            return false;
        }

        if ( empty($pageid) ) {
            return $this->get_first_user_entry($userid);
        } else {
            return get_record_sql("SELECT * FROM
                              {$CFG->prefix}learningdiary_pages
                              WHERE learningdiaryid = $ldid
                              AND userid = $userid
                              AND id = $pageid
                              AND structureid = '0'");
        }

        return false;
    }

    function _get_guided_page($userid, $structid ) {

        global $CFG;
        $ldid     = intval($this->module->id);
        $userid   = intval($userid);
        $structid = intval($structid);

        if ( empty($ldid) || empty($userid) ) {
            return NULL;
        }

        if ( empty($structid) ) {
            // Try to find users first entry where structureid is not zero
            $where = 'WHERE p.structureid = s.id';
        } else {
            $where = 'WHERE p.structureid = '. $structid;
        }

        return get_record_sql("SELECT p.id, p.structureid, p.content, p.format, s.available FROM
                              {$CFG->prefix}learningdiary_pages as p,
                              {$CFG->prefix}learningdiary_guided_structure as s
                              $where
                              AND p.learningdiaryid = $ldid
                              AND s.learningdiaryid = $ldid
                              AND p.userid = $userid
                              ORDER BY id",
                              TRUE);
    }

    function print_information ($pageid) {

        global $CFG, $USER;
        $moduleid = intval($this->cm->id);
        $courseid = intval($this->course->id);
        $ldid     = intval($this->module->id);
        $pageid   = intval($pageid);

        if ( !$info = get_record("learningdiary_guided_structure",
                                 "id", $pageid,
                                 "learningdiaryid", $ldid) ) {

            // Try to get first entry
            $info = get_record_sql("SELECT id, information, available, format FROM
                                    {$CFG->prefix}learningdiary_guided_structure
                                    WHERE learningdiaryid = $ldid
                                    ORDER BY id",
                                    TRUE);
        }

        if ( !empty($info) ) {
            if ( $info->available <= time() ) {
                $options = new stdClass;
                $options->noclean = true;
                print '<div class="mod_ld_information">';
                print(format_text(stripslashes($info->information), $info->format, $options));
                print '<div class="mod_ld_devider"></div>';

                $items = array(array('name' => 'id', 'value' => $moduleid),
                               array('name' => 'sesskey', 'value' => $USER->sesskey),
                               array('name' => 'pageid', 'value' => $info->id));


                echo '<table border="0" cellpadding="4">';
                if ( !$this->isteacher ) {
                    echo '<tr><td>';
                    $buttons = array('value' => get_string('edityourentry','learningdiary'));
                    $this->print_get_form('guideddiaryedit.php', $items, $buttons);
                    echo '</td></tr>';
                }
                echo '</table>';
                print '</div>' . "\n";
           }
        }
    }

    function print_get_form ($action, $items, $button) {

        echo '<form method="get" action="'. $action .'">' . "\n";
        if ( is_array($items) ) {
            foreach ( $items as $item ) {
                echo '<input type="hidden" name="';
                echo $item['name'] .'"';
                echo ' value="';
                echo $item['value'] .'" />' . "\n";
            }
        }
        echo '<input class="mod_ld_submit" type="submit"';
        if ( !empty($button['name']) ) {
            echo ' name="'. $button['name'] .'"';
        }
        echo ' value="'. s($button['value']) .'" />' . "\n";
        echo '</form>' . "\n";

    }

    function print_page($userid, $pageid) {

        if ( $this->module->diarymode != LD_USERMODE ) {
            $page = $this->_get_guided_page($userid, $pageid);
        } else {
            $page = $this->_get_page($userid, $pageid);
        }

        if ( !empty($page) ) {
            $this->print_tools($page->id);
        } else {
            $this->print_tools(0);
        }

        if ( $this->module->diarymode != LD_USERMODE ) {
            $pageid = !empty($page->id) ? $page->structureid : $pageid;
            $this->print_information($pageid);
        }

        if ( $this->module->diarymode != LD_USERMODE && empty($page) ) {
            print '<div class="mod_ld_noentry">';
            print_string('noguidedentryfound','learningdiary');
            print '</div>';
        }

        if ( !empty($page) ) {
            $options = new Object;
            $options->para = false;
            print(format_text(stripslashes($page->content), $page->format, $options));
        }
    }

    function _get_child_nodes ( $pid, $data ) {

        static $retval;

        if ( empty($retval) ) {
            $retval = array();
        }

        foreach ( $data as $d ) {
            if ( $pid == $d->parentid ) {
                array_push($retval, $d->id);
                $this->_get_child_nodes($d->id, $data);
            }
        }

        return $retval;
    }

    //function _get_pages_recursive ($pid, $pages, $includemain=true) {
    function _get_pages_recursive ($parentid, $current, $userid, $includemain=true, $count=0) {

        global $CFG;
        static $output;

        if ( empty($output) ) {
            $output = '';
            if ( $includemain ) {
                $output .= '<option value="0">'.
                           get_string('mainlevel','learningdiary') .
                           '</option>'."\n";
            }
        }

        $pages = get_records_sql("SELECT id, parentid, title
                                  FROM {$CFG->prefix}learningdiary_pages
                                  WHERE learningdiaryid = '{$this->module->id}'
                                  AND userid = '$userid'
                                  AND parentid = '$parentid' ORDER BY id");
        if ( !empty($pages) ) {
            foreach ($pages as $page) {

                $output .= '<option value="'. $page->id .'"';
                if ( $page->id == $current ) {
                    $output .= ' selected="selected"';
                }
                $output .= '>';
                $output .= str_repeat("&nbsp;&nbsp;&nbsp;&nbsp;", intval($count));
                $output .= s($page->title);
                $output .= '</option>'."\n";
                $this->_get_pages_recursive($page->id, $current, $userid, $includemain, $count+1);
            }
        }

        return $output;
    }

    function print_chaptermenu ($userid, $action, $submit, $current=0, $tab=1) {
        global $USER;

        ?>
        <form id="cptrId" name="cptrMenu" method="get" action="<?php p($action) ?>">
        <input type="hidden" name="id" value="<?php p($this->cm->id) ?>" />
        <input type="hidden" name="sesskey" value="<?php p($USER->sesskey) ?>" />
        <input type="hidden" name="tab" value="<?php p($tab) ?>" />
        <select name="pageid" onchange="<?php p($submit) ?>">
        <?php
        $levels = $this->_get_levels($userid, $current, false);
        //choose_from_menu($levels, "pageid", "$current", "", $submit);
        echo $levels;
        ?>
        </select>
        </form>
        <noscript>
        <input type="submit" value="<?php print_string('choose') ?>" />
        </noscript>
        <?php
    }

    function _get_levels ($userid, $current=0, $includemain=true, $mode='add') {

        global $CFG;
        $ldid     = intval($this->module->id);
        $userid   = intval($userid);

        $output = $this->_get_pages_recursive(0, $current, $userid, $includemain);

        return $output;
    }

    function print_student_menu ($current=0) {

        global $CFG,$USER;

        $students = '';
        $fullname = sql_fullname('u.firstname', 'u.lastname');
        $where = " WHERE l.learningdiaryid = '{$this->module->id}'";
        if ( $this->module->diarymode != LD_GUIDEDMODE ) {
            $where .= " AND l.structureid = 0";
        }

        $students = get_records_sql_menu("SELECT DISTINCT u.id, $fullname AS name
                                          FROM
                                              {$CFG->prefix}user u
                                          INNER JOIN
                                              {$CFG->prefix}learningdiary_pages l
                                          ON u.id = l.userid
                                          $where");
        if ( !empty($students) ) {
            ?>
            <form id="stdMenuID" name="stdMenu" method="get" action="view.php">
            <input type="hidden" name="id" value="<?php p($this->cm->id) ?>" />
            <input type="hidden" name="sesskey" value="<?php p($USER->sesskey) ?>" />
            <p style="text-align: center">
            <?php
            choose_from_menu($students, "student", $current, get_string("choose","learningdiary",
                             strtolower($this->course->student)), "document.getElementById('stdMenuID').submit()");
            ?>
            <input type="submit" value=" &raquo; " />
            </p>
            </form>
           <?php
        }

    }

    function format_html ( $strhtml ) {

        $blockelems = "/(<\/(html|head|body|title|h1|h2|h3|h4|h5|h6|" .
                      "address|blockquote|del|ins|div|fieldset|form|" .
                      "hr|noscript|p|pre|script|table|tr|td|dl|ol|ul|" .
                      "dt|dd|li)+>)/i";
        $brhr = "/(<(br|hr) ?\/?>)/i";

        // Make one line.
        $strhtml = preg_replace("/\n/", "", $strhtml);
        $strhtml = preg_replace("/\r/", "", $strhtml);
        // Add returns.
        $strhtml = preg_replace($blockelems, "$0\r\n", $strhtml);
        $strhtml = preg_replace($brhr, "$0\r\n", $strhtml);

        return $strhtml;
    }

    function diff($str1, $str2) {
        global $CFG;

        error_reporting(0); // Get rid off errors and notices.

        $htmlmode = true;
        $o = '';
        # Different handling for html: closes Bug #1530 - Wiki diffs useless when using HTML editor
        if(! empty( $htmlmode )) {
            $content0 = htmlentities($this->format_html($str1));
            $content  = htmlentities($this->format_html($str2));
        } else {
            $content0 = $str1;
            $content = $str2;
        }

        if ( empty($htmlmode) ) {
            $txt0 = $this->_string2sentences(trim($content0));
            $txt2 = $this->_string2sentences(trim($content));
        } else {
            $txt0 = explode("\n", $content0);
            $txt2 = explode("\n", $content);
        }

        $diff0 = array_diff($txt0, $txt2);
        $diff2 = array_diff($txt2, $txt0);

        foreach ($txt2 as $i => $line) {

            $i2 = $i;

            while ( $rm = $diff0[$i2++] ) {
                if(! empty($htmlmode)) {
                    $o .= "<strong>-</strong> <font color=\"#990000\">$rm</font>\n";
                } else {
                    $o .= "<strong>-</strong> <font color=\"#990000\"><tt>$rm</tt></font>\n";
                }
                unset($diff0[$i2-1]);
            }

            if (in_array($line, $diff2)) {
                if(! empty($htmlmode)) {
                    $o .= "<strong>+</strong> <font color=\"#009900\">$line</font>\n";
                } else {
                    $o .= "<strong>+</strong> <font color=\"#009900\"><tt>$line</tt></font>\n";
                }
            } else {
                if(! empty($htmlmode)) {
                    $o .= "$line\n";
                } else {
                    $o .= "&nbsp; $line<br />\n";
                }
            }
        }

        foreach ($diff0 as $rm) {
            $o .= "<strong>-</strong> <font color=\"#990000\"> <tt>$rm</tt></font>\n";
        }
        error_reporting($CFG->debug);
        return(nl2br($o));
    }

    function _string2sentences($string) {

        $sep = "!.?;\n";
        $sentences = 0;
        for ($token = strtok($string, $sep); $token !== FALSE; $token = strtok($sep)) {
            if ( $token != '' ) {
                if ( empty($sentencecount[$token]) ) {
                    $sentence[] = addslashes($token . ".");
                }
                $sentences++;
            }
        }
        $array = $sentence;
        return $array;

    }

    function print_comments ($studentid, $pageid) {

        global $CFG, $USER;
        $inputpageid = $pageid; // Cache this for later use.

        if ( $this->module->diarymode != LD_USERMODE) {
            // Get page info
            $pageid = get_field("learningdiary_pages", "id",
                                "structureid", $pageid,
                                "learningdiaryid", $this->module->id,
                                "userid", $studentid);
        }

        if ( !empty($pageid) ) {
            $fields = "id, title, userid, teacherid, comment, modified, format";
            $comments = get_records_sql("SELECT $fields
                                         FROM {$CFG->prefix}learningdiary_comments
                                         WHERE pageid = $pageid
                                         AND learningdiaryid = {$this->module->id}
                                         AND userid = $studentid
                                         ORDER BY modified");
        }

        if ( !empty($comments) ) {
            $stredit   = get_string('edit');
            $strdelete = get_string('delete');
            $count = 1;
            foreach ( $comments as $comment ) {
                $teacher = get_record_sql("SELECT firstname, lastname
                                           FROM {$CFG->prefix}user
                                           WHERE id = ". addslashes($comment->teacherid));

                echo '<table class="mod_ld_comment_head" border="0" cellpadding="4"';
                echo ' cellspacing="2" width="100%">' . "\n";
                echo '<tr><td>';
                echo stripslashes($comment->title);
                echo ' (<em>'. fullname($teacher) .'</em> ';
                echo userdate($comment->modified) .')';
                echo '</td></tr></table>';

                echo '<table id="inst$count" border="0" cellpadding="4"';
                echo ' cellspacing="2" width="100%">' . "\n";
                echo '<tr valign="top"><td>';
                $options = new stdClass;
                $options->para = false;
                echo '<div class="mod_ld_comment_body">';
                print(format_text(stripslashes($comment->comment), $comment->format, $options));
                echo '</div>'."\n";
                echo '<div class="mod_ld_comment_links">';
                $baselink = '<a href="guidedteachertools.php?id='. $this->cm->id .
                            '&amp;sesskey='. $USER->sesskey .'&amp;pageid=';
                $editlink = ($comment->teacherid == $USER->id) ?
                             $baselink . $inputpageid . '&amp;studentid='. $studentid .
                             '&amp;comment='. $comment->id .
                             '&amp;action=edit">'. $stredit .'</a>' : '';
                $delelink = ($comment->teacherid == $USER->id or $this->isadmin ) ?
                             $baselink . $pageid . '&amp;studentid='. $studentid .
                             '&amp;comment='. $comment->id .
                             '&amp;action=deletecomment">'. $strdelete .'</a>' : '';

                echo !empty($editlink) ? $editlink : '';
                echo (!empty($editlink) && !empty($delelink)) ? ' | ' : '';
                echo !empty($delelink) ? $delelink : '';
                echo '</div>'."\n";
                echo '</td></tr>' . "\n";
                echo '</table>';
                $count++;
            }
        }

        if ( $this->module->diarymode != LD_USERMODE &&
             $this->isteacher &&
             !empty($pageid) ) {

            $items = array(array('name' => 'id', 'value' => $this->cm->id),
                           array('name' => 'sesskey', 'value' => $USER->sesskey),
                           array('name' => 'pageid', 'value' => $inputpageid),
                           array('name' => 'studentid', 'value' => $studentid),
                           array('name' => 'action', 'value' => 'add'));

            $buttons = array('name' => 'comment', 'value' => get_string('addcomment','learningdiary'));
            echo '<table border="0" cellpadding="2">';
            echo '<tr><td>';
            $this->print_get_form('guidedteachertools.php', $items, $buttons);
            echo '</td><td>';
            $items[4]['value'] = 'delete';
            $buttons = array('name' => 'delete', 'value' => get_string('deleteuserentry','learningdiary'));
            $this->print_get_form('guidedteachertools.php', $items, $buttons);
            echo '</td></tr>';
            echo '</table>';
        }
    }

    function check_confirm_key($key) {
        global $USER;
        if ( empty($USER->ldconfirmkey) ) {
            return false;
        }
        return ( $USER->ldconfirmkey === $key );
    }

    function tabs ($tabnumber=0) {
        global $CFG, $USER;

        if ( empty($tabnumber) ) {
            $tab = optional_param('tab', 0, PARAM_INT);
        } else {
            $tab = $tabnumber;
        }

        $currenttab = NULL;
        $tabrow  = array();
        $topurl  = "$CFG->wwwroot/mod/learningdiary/view.php?id={$this->cm->id}&amp;sesskey=$USER->sesskey";

        switch ($this->module->diarymode) {
            //case 1: // Meaning both modes.
            //break;
            case LD_USERMODE: // Only user diary.
                $diarypages = array(1 => 'userdiary', 2 => 'history');

                switch ($tab) {
                    case 1:
                        $currenttab = $diarypages[$tab];
                    break;
                    case 2:
                        $currenttab = $diarypages[$tab];
                    break;
                    case 3:
                        $currenttab = NULL;
                    break;
                    default:
                        $currenttab = $diarypages[1];
                }

                $historyurl = 'diaryhistory.php?id='. $this->cm->id .
                              '&amp;sesskey='. $USER->sesskey;
                $tabrow[] = new tabObject('userdiary',
                                          $topurl . '&amp;tab=1',
                                          get_string('userdiary','learningdiary'));
                $tabrow[] = new tabObject('history',
                                          $historyurl .'&amp;tab=2',
                                          get_string('chapterhistory','learningdiary'));
            break;
            case LD_GUIDEDMODE: // Only guided diary.

                $diarypages = array(1 => 'learningdiary', 2 => 'history', 3 => 'management', 4 => NULL);
                if ( $tab > 0 ) {
                    $currenttab = $diarypages[$tab];
                } else {
                    $currenttab = $diarypages[1];
                }

                $historyurl    = 'diaryhistory.php?id=' . $this->cm->id .
                                 '&amp;sesskey='. $USER->sesskey;
                $managementurl = 'management.php?id='. $this->cm->id .
                                 '&amp;sesskey='. $USER->sesskey;

                $tabrow[] = new tabObject('learningdiary',
                                          $topurl .'&amp;tab=1',
                                          get_string('guideddiary','learningdiary'));
                $tabrow[] = new tabObject('history',
                                          $historyurl .'&amp;tab=2',
                                          get_string('chapterhistory','learningdiary'));
                if ( $this->isteacher ) {
                    $tabrow[] = new tabObject('management',
                                              $managementurl .'&amp;tab=3',
                                              get_string('management','learningdiary'));
                }
            break;
        }

        $tabs = array($tabrow);
        print_tabs($tabs, $currenttab);
    }

} // modLearningdiary class ends.
?>