<?php // $Id: guidedteachertools.php,v 1.4 2006/08/28 22:06:13 janne Exp $

    require_once("../../config.php");
    require_once("lib.php");

    $diary  = new modLearningdiary();
    $skey   = required_param('sesskey', PARAM_ALPHANUM);
    $tab    = optional_param('tab',  1, PARAM_INT);
    $action = optional_param('action', 'add', PARAM_ALPHA);

    if ( !$diary->isteacher ) {
        error("Only teachers can view this page!",
              "$CFG->wwwroot/mod/learningdiary/view.php?id=$cm->id");
    }

    if ( !confirm_sesskey($skey) ) {
        error("Session key error!!!");
    }

    if ( $data = data_submitted() ) {

        if ( !empty($data->cancel) ) {
            redirect("$CFG->wwwroot/mod/learningdiary/view.php?id={$diary->cm->id}");
            exit;
        }

        if ( !empty($data->pageid) && !empty($data->userid) ) {
            // Delete users entry.
            $pageid  = clean_param($data->pageid, PARAM_INT);
            $userid  = clean_param($data->userid, PARAM_INT);
            $diaryid = clean_param($diary->module->id, PARAM_INT);
            if ( delete_records("learningdiary_pages", "id", $pageid,
                                "userid", $userid, "learningdiaryid", $diaryid) ) {
                // Delete page history
                delete_records("learningdiary_pages_history", "pageid", $pageid,
                               "learningdiaryid", $diaryid);
                // Delete comments.
                delete_records("learningdiary_comments", "learningdiaryid", $diaryid,
                               "userid", $userid, "pageid", $pageid);
            } else {
                error("Could not delete requested user entry!",
                      $CFG->wwwroot ."/mod/learningdiary/view.php?id=". $diary->cm->id);
            }

            $message = get_string('deletesuccess','learningdiary');
            redirect("view.php?id={$diary->cm->id}", $message, 2);

        }

    }

    // Are we deleting teacher comment?
    if ( $action == 'deletecomment' ) {
        $pageid = required_param('pageid', PARAM_INT);
        $commentid = required_param('comment', PARAM_INT);

        if ( $comment = get_record("learningdiary_comments", "id", $commentid,
                                   "pageid", $pageid, "teacherid", $USER->id) ) {
            // Delete comment.
            if ( delete_records("learningdiary_comments", "id", $comment->id) ) {
                $redirectpage = get_field("learningdiary_pages", "id", "structureid", $pageid);
                $message = get_string('commentdeleted','learningdiary');
                redirect("view.php?id={$diary->cm->id}&amp;pageid=$redirectpage", $message, 1);
           }
        } else {
            if ( isadmin() ) { // If user is admin user.
                echo "Pageid: $pageid Commentid: $commentid";
                if ( $comment = get_record("learningdiary_comments", "id", $commentid,
                                           "pageid", $pageid) ) {
                    // Delete comment.
                    if ( delete_records("learningdiary_comments", "id", $comment->id) ) {
                        $redirectpage = get_field("learningdiary_pages", "id", "structureid", $pageid);
                        $message = get_string('commentdeleted','learningdiary');
                        redirect("view.php?id={$diary->cm->id}&amp;pageid=$redirectpage", $message, 1);
                    }
           }
       } else {
           error("Could not find requested comment!!!",
                 $CFG->wwwroot .'/mod/learningdiary/view.php?id='. $diary->cm->id);
        }
        }
        $comment->title = !empty($comment->title) ? stripslashes($comment->title) : '';
        error("Could not delete comment {$comment->title}!!!",
              $CFG->wwwroot .'/mod/learningdiary/view.php?id='. $diary->cm->id);
    }

    $navigation = '';
    if ($diary->course->category) {
        $navigation = "<a href=\"../../course/view.php?id={$diary->course->id}\">{$diary->course->shortname}</a> ->";
    }

    $strlearningdiaries = get_string("modulenameplural", "learningdiary");
    $strlearningdiary   = get_string("modulename", "learningdiary");
    $strpageaction = ($action != 'edit') ?
                      get_string('addcomment','learningdiary') :
                      (($action != 'delete') ? get_string('edit') : get_string('delete'));

    $usehtmleditor = can_use_html_editor();

    print_header("{$diary->course->shortname}: {$diary->module->name}", "{$diary->course->fullname}",
                 "$navigation <a href=\"index.php?id={$diary->course->id}\">$strlearningdiaries</a> -> ".
                 "<a href=\"view.php?id={$diary->cm->id}\">{$diary->module->name}</a> -> $strpageaction",
                 "", "", true,
                 update_module_button($diary->cm->id, $diary->course->id, $strlearningdiary),
                 navmenu($diary->course, $diary->cm));

    $diary->tabs($tab);
    print_simple_box_start('center', '100%');

    // Add or edit comment.
    if ( $action == 'add' or $action == 'edit' ) {
        $pageid = required_param('pageid', PARAM_INT);
        $studentid = required_param('studentid', PARAM_INT);

        if ( !$page = get_record_sql("SELECT p.id, p.title, p.content, p.userid, s.information FROM
                                      {$CFG->prefix}learningdiary_pages AS p,
                                      {$CFG->prefix}learningdiary_guided_structure AS s
                                      WHERE p.structureid = $pageid
                                      AND s.id = $pageid
                                      AND p.userid = $studentid
                                      AND p.learningdiaryid = s.learningdiaryid") ) {
            error("Page you have requested does not exists!",
                  "$CFG->wwwroot/mod/learningdiary/view.php?id={$diary->cm->id}");
        }
        if ( !$userinfo = get_record_sql("SELECT id, firstname, lastname FROM
                                         {$CFG->prefix}user
                                         WHERE id = $page->userid") ) {
            error("Could not get user information for this entry!",
                  "$CFG->wwwroot/mod/learningdiary/view.php?id={$diary->cm->id}");
        }

        $form = new stdClass;
        $form->title = '';
        $form->comment = '';
        $form->format = '';
        if ( $action != 'add' ) {
            $commentid = required_param('comment', PARAM_INT);
            if ( $comment = get_record("learningdiary_comments", "id", $commentid,
                                       "pageid", $page->id, "teacherid", $USER->id) ) {
                $form->commentid = $comment->id;
                $form->comment = stripslashes($comment->comment);
                $form->title = stripslashes($comment->title);
                $form->format = $comment->format;
            }
        }

        $studentname = fullname($userinfo);
        $commentheading  = $studentname;
        $commentheading .= ' '. get_string('chapter','learningdiary') .': ';
        $commentheading .= stripslashes(htmlentities($page->title));

        print_simple_box_start('center', '80%');
        print_heading($commentheading, 'center');
        ?>
        <form method="post" action="savecomment.php">
        <input type="hidden" name="id" value="<?php p($diary->cm->id) ?>" />
        <input type="hidden" name="sesskey" value="<?php p($USER->sesskey) ?>" />
        <?php
        if ( !empty($form->commentid) ) {
            echo '<input type="hidden" name="commentid" value="'. s($form->commentid) .'" />'."\n";
        }
        ?>
        <input type="hidden" name="pageid" value="<?php p($page->id) ?>" />
        <input type="hidden" name="userid" value="<?php p($userinfo->id) ?>" />
        <input type="hidden" name="teacherid" value="<?php p($USER->id) ?>" />
        <input type="hidden" name="action" value="<?php p($action) ?>" />
        <table border="0" cellpadding="4" cellspacing="2" align="center">
        <tr valign="top">
            <td align="right"><?php print_string('title','learningdiary') ?>:</td>
            <td><input type="text" name="title" value="<?php p($form->title) ?>" size="60" /></td>
        </tr>
        <tr valign="top">
            <td align="right"><?php print_string('comment','learningdiary') ?>:</td>
            <td><?php
            print_textarea($usehtmleditor, "20", "60", "", "", "comment", $form->comment, $diary->course->id);
            ?><br />
        <?php
        if ($usehtmleditor) {   /// Trying this out for a while
            print_string('formathtml');
            echo '<input type="hidden" name="format" value="'.FORMAT_HTML.'" />';
        } else {
            choose_from_menu(format_text_menu(), "format", $form->format, "");
        }
        helpbutton("textformat", get_string("helpformatting"));
            ?></td>
        </tr>
        <tr>
            <td>&nbsp;</td>
            <td><input type="submit" value="<?php print_string('savechanges') ?>" />
            <input type="submit" name="cancel" value="<?php print_string('cancel') ?>" /></td>
        </tr>
        </table>
        </form>
        <?php
        print_simple_box_end();
    }

    // Delete
    if ( $action == 'delete' ) {
        $userid = required_param('studentid', PARAM_INT);
        $pageid = required_param('pageid', PARAM_INT);

        if ( !$page = get_record("learningdiary_pages", "structureid", $pageid,
                                 "userid", $userid,
                                 "learningdiaryid", $diary->module->id) ) {
            error("Page you have requested does not exists!",
                  "$CFG->wwwroot/mod/learningdiary/view.php?id={$diary->cm->id}");
        }

        if ( !$userinfo = get_record_sql("SELECT id, firstname, lastname FROM
                                         {$CFG->prefix}user
                                         WHERE id = $page->userid") ) {
            error("Could not get user information for this entry!",
                  "$CFG->wwwroot/mod/learningdiary/view.php?id={$diary->cm->id}");
        }

        $userfullname = fullname($userinfo);

        print_simple_box_start('center', '80%');
        ?>
        <form method="post" action="guidedteachertools.php">
        <input type="hidden" name="id" value="<?php p($diary->cm->id) ?>" />
        <input type="hidden" name="sesskey" value="<?php p($USER->sesskey) ?>" />
        <input type="hidden" name="pageid" value="<?php p($page->id) ?>" />
        <input type="hidden" name="userid" value="<?php p($userinfo->id) ?>" />
        <center>
        <p><?php print_string('chapter','learningdiary') ?>: <strong><?php
        print(stripslashes($page->title)); ?></strong></p>
        <p><?php print_string('confirmuserentrydelete','learningdiary', stripslashes($userfullname)); ?><br /><br />
        <input type="submit" value="<?php print_string('yes') ?>" />
        <input type="submit" name="cancel" value="<?php print_string('no') ?>" />
        </p>
        </center>
        </form>
        <?php
        print_simple_box_end();
    }


    print_simple_box_end();

    if  ( $action && $usehtmleditor ) {
        use_html_editor();
    }
    print_footer($diary->course);
?>