<?php // $Id: migrate2utf8.php,v 1.2 2006/11/28 13:00:59 janne Exp $

function migrate2utf8_learningdiary_name($recordid){
    global $CFG, $globallang;

/// Some trivial checks
    if (empty($recordid)) {
        log_the_problem_somewhere();
        return false;
    }

    if (!$diary = get_record('learningdiary', 'id', $recordid)) {
        log_the_problem_somewhere();
        return false;
    }

    if ($globallang) {
        $fromenc = $globallang;
    } else {
        $sitelang   = $CFG->lang;
        $courselang = get_course_lang($diary->course);  //Non existing!
        $userlang   = get_main_teacher_lang($diary->course); //N.E.!!

        $fromenc = get_original_encoding($sitelang, $courselang, $userlang);
    }

/// We are going to use textlib facilities

/// Convert the text
    if (($fromenc != 'utf-8') && ($fromenc != 'UTF-8')) {
        $result = utfconvert($diary->name, $fromenc);

        $newtext = new object;
        $newtext->id = $recordid;
        $newtext->name = $result;
        migrate2utf8_update_record('learningdiary', $newtext);
    }
/// And finally, just return the converted field
    return $result;
}

function migrate2utf8_learningdiary_intro($recordid){
    global $CFG, $globallang;

/// Some trivial checks
    if (empty($recordid)) {
        log_the_problem_somewhere();
        return false;
    }

    if (!$diary = get_record('learningdiary', 'id', $recordid)) {
        log_the_problem_somewhere();
        return false;
    }

    if ($globallang) {
        $fromenc = $globallang;
    } else {
        $sitelang   = $CFG->lang;
        $courselang = get_course_lang($diary->course);  //Non existing!
        $userlang   = get_main_teacher_lang($diary->course); //N.E.!!

        $fromenc = get_original_encoding($sitelang, $courselang, $userlang);
    }

/// We are going to use textlib facilities

/// Convert the text
    if (($fromenc != 'utf-8') && ($fromenc != 'UTF-8')) {
        $result = utfconvert($diary->intro, $fromenc);

        $newtext = new object;
        $newtext->id = $recordid;
        $newtext->intro = $result;
        migrate2utf8_update_record('learningdiary', $newtext);
    }
/// And finally, just return the converted field
    return $result;
}

function migrate2utf8_learningdiary_guided_structure_title($recordid){
    global $CFG, $globallang;

/// Some trivial checks
    if (empty($recordid)) {
        log_the_problem_somewhere();
        return false;
    }

    $SQL = "SELECT ld.*, l.course
            FROM {$CFG->prefix}learningdiary_guided_structure ld
            INNER JOIN {$CFG->prefix}learningdiary l
            ON ld.learningdiaryid = l.id
            WHERE ld.learningdiaryid = $recordid";

    if (!$diaries = get_records_sql($SQL)) {
        log_the_problem_somewhere();
        return false;
    }

    foreach ( $diaries as $diary ) {

        if ($globallang) {
            $fromenc = $globallang;
        } else {
            $sitelang   = $CFG->lang;
            $courselang = get_course_lang($diary->course);  //Non existing!
            $userlang   = get_main_teacher_lang($diary->course); //N.E.!!

            $fromenc = get_original_encoding($sitelang, $courselang, $userlang);
        }

    /// We are going to use textlib facilities

    /// Convert the text
        if (($fromenc != 'utf-8') && ($fromenc != 'UTF-8')) {
            $result = utfconvert($diary->title, $fromenc);

            $newtext = new object;
            $newtext->id = $recordid;
            $newtext->title = $result;
            migrate2utf8_update_record('learningdiary_guided_structure',$newtext);
        }
    }

/// And finally, just return the converted field
    return $result;
}

function migrate2utf8_learningdiary_guided_structure_information($recordid) {
    global $CFG, $globallang;

/// Some trivial checks
    if (empty($recordid)) {
        log_the_problem_somewhere();
        return false;
    }

    $SQL = "SELECT ld.*, l.course
            FROM {$CFG->prefix}learningdiary_guided_structure ld
            INNER JOIN {$CFG->prefix}learningdiary l
            ON ld.learningdiaryid = l.id
            WHERE ld.learningdiaryid = $recordid";

    if (!$diaries = get_records_sql($SQL)) {
        log_the_problem_somewhere();
        return false;
    }

    foreach ( $diaries as $diary ) {

        if ($globallang) {
            $fromenc = $globallang;
        } else {
            $sitelang   = $CFG->lang;
            $courselang = get_course_lang($diary->course);  //Non existing!
            $userlang   = get_main_teacher_lang($diary->course); //N.E.!!

            $fromenc = get_original_encoding($sitelang, $courselang, $userlang);
        }

    /// We are going to use textlib facilities

    /// Convert the text
        if (($fromenc != 'utf-8') && ($fromenc != 'UTF-8')) {
            $result = utfconvert($diary->information, $fromenc);

            $newtext = new object;
            $newtext->id = $recordid;
            $newtext->information = $result;
            migrate2utf8_update_record('learningdiary_guided_structure',$newtext);
        }
    }
/// And finally, just return the converted field
    return $result;
}

?>